/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javafx.animation.FadeTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.LauncherConfiguration;
import org.terasology.launcher.LauncherInitTask;
import org.terasology.launcher.model.LauncherVersion;
import org.terasology.launcher.ui.ApplicationController;
import org.terasology.launcher.util.BundleUtils;
import org.terasology.launcher.util.HostServices;
import org.terasology.launcher.util.Languages;
import org.terasology.launcher.util.LauncherStartFailedException;

public final class TerasologyLauncher
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(TerasologyLauncher.class);
    private static final int SPLASH_WIDTH = 800;
    private static final int SPLASH_HEIGHT = 223;
    private Pane splashLayout;
    private ProgressBar loadProgress;
    private Label progressText;
    private Stage mainStage;
    private HostServices hostServices;

    public static void main(String[] args) {
        TerasologyLauncher.launch((String[])args);
    }

    public void init() {
        ImageView splash = new ImageView(BundleUtils.getFxImage("splash"));
        this.loadProgress = new ProgressBar();
        this.loadProgress.setPrefWidth(800.0);
        this.progressText = new Label();
        this.splashLayout = new VBox();
        this.splashLayout.getChildren().addAll((Object[])new Node[]{splash, this.loadProgress, this.progressText});
        this.progressText.setAlignment(Pos.CENTER);
        this.splashLayout.getStylesheets().add((Object)BundleUtils.getStylesheet("css_splash"));
        this.splashLayout.setEffect((Effect)new DropShadow());
        this.hostServices = new HostServices();
    }

    public void start(Stage initialStage) {
        logger.info("TerasologyLauncher is starting");
        this.logSystemInformation();
        TerasologyLauncher.initProxy();
        this.initLanguage();
        LauncherInitTask launcherInitTask = new LauncherInitTask(initialStage, this.hostServices);
        this.showSplashStage(initialStage, launcherInitTask);
        Thread initThread = new Thread((Runnable)((Object)launcherInitTask));
        initThread.setName("Launcher init thread");
        initThread.setUncaughtExceptionHandler((t, e) -> logger.warn("Initialization failed!", e));
        launcherInitTask.setOnSucceeded(workerStateEvent -> {
            try {
                LauncherConfiguration config = (LauncherConfiguration)launcherInitTask.getValue();
                if (config == null) {
                    throw new LauncherStartFailedException("Launcher configuration was `null`.");
                }
                this.showMainStage(config);
            }
            catch (IOException | LauncherStartFailedException e) {
                logger.error("The TerasologyLauncher could not be started!", e);
                System.exit(1);
            }
        });
        launcherInitTask.setOnFailed(event -> {
            logger.error("The TerasologyLauncher could not be started!", event.getSource().getException());
            System.exit(1);
        });
        launcherInitTask.setOnCancelled(event -> Platform.exit());
        initThread.start();
    }

    private static void initProxy() {
        System.setProperty("java.net.useSystemProxies", "true");
    }

    private void showMainStage(LauncherConfiguration launcherConfiguration) throws IOException {
        Parent root;
        FXMLLoader fxmlLoader;
        this.mainStage = new Stage(StageStyle.DECORATED);
        try {
            fxmlLoader = BundleUtils.getFXMLLoader("application");
            root = (Parent)fxmlLoader.load();
        }
        catch (IOException e) {
            fxmlLoader = BundleUtils.getFXMLLoader("application");
            fxmlLoader.setResources(ResourceBundle.getBundle("org.terasology.launcher.bundle.LabelsBundle", Languages.DEFAULT_LOCALE));
            root = (Parent)fxmlLoader.load();
        }
        ApplicationController controller = (ApplicationController)fxmlLoader.getController();
        controller.update(launcherConfiguration.getLauncherDirectory(), launcherConfiguration.getDownloadDirectory(), launcherConfiguration.getLauncherSettings(), launcherConfiguration.getRepositoryManager(), launcherConfiguration.getGameManager(), this.mainStage, this.hostServices);
        Scene scene = new Scene(root);
        scene.getStylesheets().add((Object)BundleUtils.getStylesheet("css_terasology"));
        TerasologyLauncher.decorateStage(this.mainStage);
        this.mainStage.setScene(scene);
        this.mainStage.setResizable(true);
        this.mainStage.show();
        logger.info("The TerasologyLauncher was successfully started.");
    }

    private void showSplashStage(Stage initialStage, Task<LauncherConfiguration> task) {
        this.progressText.textProperty().bind((ObservableValue)task.messageProperty());
        this.loadProgress.progressProperty().bind((ObservableValue)task.progressProperty());
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                this.loadProgress.progressProperty().unbind();
                this.loadProgress.setProgress(1.0);
                if (this.mainStage != null) {
                    this.mainStage.setIconified(false);
                }
                initialStage.toFront();
                FadeTransition fadeSplash = new FadeTransition(Duration.seconds((double)1.2), (Node)this.splashLayout);
                fadeSplash.setFromValue(1.0);
                fadeSplash.setToValue(0.0);
                fadeSplash.setOnFinished(actionEvent -> initialStage.hide());
                fadeSplash.play();
            }
        });
        TerasologyLauncher.decorateStage(initialStage);
        Scene splashScene = new Scene((Parent)this.splashLayout);
        initialStage.initStyle(StageStyle.UNDECORATED);
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        initialStage.setScene(splashScene);
        initialStage.setX(bounds.getMinX() + bounds.getWidth() / 2.0 - 400.0);
        initialStage.setY(bounds.getMinY() + bounds.getHeight() / 2.0 - 111.0);
        initialStage.show();
    }

    private void logSystemInformation() {
        if (logger.isDebugEnabled()) {
            logger.debug("Java: {} {} {}", System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.home"));
            logger.debug("Java VM: {} {} {}", System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version"));
            logger.debug("Java classpath: {}", (Object)System.getProperty("java.class.path"));
            logger.debug("OS: {} {} {}", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"));
            logger.debug("Max. Memory: {} bytes", (Object)Runtime.getRuntime().maxMemory());
            logger.debug("Launcher version: {}", (Object)LauncherVersion.getInstance());
        }
    }

    private void initLanguage() {
        logger.trace("Init Languages...");
        Languages.init();
        logger.debug("Language: {}", (Object)Languages.getCurrentLocale());
    }

    private static void decorateStage(Stage stage) {
        stage.setTitle("TerasologyLauncher");
        List<String> iconIds = Arrays.asList("icon16", "icon32", "icon64", "icon128");
        for (String id : iconIds) {
            try {
                Image image = BundleUtils.getFxImage(id);
                stage.getIcons().add((Object)image);
            }
            catch (MissingResourceException e) {
                logger.warn("Could not load icon image", e);
            }
        }
    }
}

