/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.game;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.vdurmont.semver4j.Semver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Installation {
    final Path path;

    Installation(Path installDirectory) {
        this.path = (Path)Preconditions.checkNotNull((Object)installDirectory);
    }

    static Installation getExisting(Path directory) throws FileNotFoundException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new FileNotFoundException("No installation present in " + directory);
        }
        return new Installation(directory);
    }

    Semver getEngineVersion() throws IOException {
        return Installation.getEngineVersion(this.path);
    }

    Path getGameJarPath() throws IOException {
        return Installation.findJar(this.path, Installation::matchGameJar, "game");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Installation)) {
            return false;
        }
        Installation that = (Installation)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).toString();
    }

    static Path findJar(Path searchPath, BiPredicate<Path, BasicFileAttributes> predicate, String displayName) throws IOException {
        Path resultPath;
        try (Stream<Path> jarMatches = Files.find(searchPath, 3, predicate, new FileVisitOption[0]);){
            Set matches = jarMatches.collect(Collectors.toUnmodifiableSet());
            if (matches.isEmpty()) {
                throw new FileNotFoundException("Could not find " + displayName + " jar in " + searchPath);
            }
            if (matches.size() > 1) {
                throw new FileNotFoundException(String.format("Ambiguous results while looking for " + displayName + " jar in %s: %s", searchPath, matches));
            }
            resultPath = (Path)matches.iterator().next();
        }
        return resultPath;
    }

    static Semver getEngineVersion(Path versionDirectory) throws IOException {
        Path engineJar = Installation.findJar(versionDirectory, Installation::matchEngineJar, "engine");
        Properties versionInfo = Installation.getVersionPropertiesFromJar(engineJar);
        return new Semver(versionInfo.getProperty("engineVersion"), Semver.SemverType.IVY);
    }

    static BiPredicate<Path, BasicFileAttributes> matchJar(Predicate<String> predicate) {
        return (path, basicFileAttributes) -> {
            Set<Path> libPaths = Set.of(Path.of("lib", new String[0]), Path.of("libs", new String[0]));
            Path parent = path.getParent();
            String file = path.getFileName().toString();
            return Files.isDirectory(parent, new LinkOption[0]) && libPaths.contains(parent.getFileName()) && predicate.test(file);
        };
    }

    static boolean matchEngineJar(Path path, BasicFileAttributes basicFileAttributes) {
        return Installation.matchJar(file -> file.endsWith(".jar") && file.startsWith("engine")).test(path, basicFileAttributes);
    }

    static boolean matchGameJar(Path path, BasicFileAttributes basicFileAttributes) {
        return Installation.matchJar(file -> file.equals("Terasology.jar")).test(path, basicFileAttributes);
    }

    static Properties getVersionPropertiesFromJar(Path jarLocation) throws IOException {
        try (JarFile jar = new JarFile(jarLocation.toFile());){
            Optional<JarEntry> versionEntry = jar.stream().filter(entry -> entry.getName().endsWith("versionInfo.properties")).findAny();
            if (versionEntry.isEmpty()) {
                throw new FileNotFoundException("Found no versionInfo.properties in " + jarLocation);
            }
            Properties properties = new Properties();
            try (InputStream input = jar.getInputStream(versionEntry.get());){
                properties.load(input);
            }
            Properties properties2 = properties;
            return properties2;
        }
    }
}

