/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.game;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.ui.FxTimer;

class RunGameTask
extends Task<Boolean> {
    static final int EXIT_CODE_OK = 0;
    static final Predicate<String> START_MATCH = Pattern.compile("TerasologyEngine.+Initialization completed").asPredicate();
    static final Duration SURVIVAL_THRESHOLD = Duration.ofSeconds(10L);
    private static final Logger logger = LoggerFactory.getLogger(RunGameTask.class);
    protected final Callable<Process> starter;
    private boolean valueSet;
    private FxTimer successTimer;

    RunGameTask(Callable<Process> starter) {
        this.starter = starter;
    }

    protected Boolean call() throws GameStartError, GameExitError, InterruptedException, GameExitTooSoon {
        Process process;
        Verify.verifyNotNull(this.starter);
        Verify.verify((!this.isDone() ? 1 : 0) != 0);
        try {
            process = this.starter.call();
        }
        catch (Exception e) {
            throw new GameStartError(e);
        }
        this.monitorProcess(process);
        return true;
    }

    void monitorProcess(Process process) throws InterruptedException, GameExitError, GameExitTooSoon {
        Preconditions.checkNotNull((Object)process);
        logger.debug("Game process is {}", (Object)process);
        this.updateMessage("Game running as process " + process.pid());
        this.startTimer();
        try (BufferedReader gameOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            gameOutput.lines().forEachOrdered(this::handleOutputLine);
        }
        catch (IOException e) {
            logger.error("Exception reading process output.", e);
        }
        try {
            int exitValue = process.waitFor();
            logger.debug("Game closed with the exit value '{}'.", (Object)exitValue);
            if (exitValue != 0) {
                this.updateMessage("Process exited with code " + exitValue);
                throw new GameExitError(exitValue);
            }
            this.updateMessage("Process complete.");
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for game process exit.", e);
            throw e;
        }
        if (this.successTimer != null) {
            this.removeTimer();
            throw new GameExitTooSoon();
        }
    }

    protected void handleOutputLine(String line) {
        if (!this.valueSet && START_MATCH.test(line)) {
            this.declareSurvival();
        }
        logger.info("Game output: {}", (Object)line);
    }

    private void declareSurvival() {
        this.valueSet = true;
        this.updateValue(true);
        this.removeTimer();
    }

    private void timerComplete() {
        logger.debug("Process has been alive at least {}, calling it good.", (Object)SURVIVAL_THRESHOLD);
        this.declareSurvival();
    }

    protected void startTimer() {
        this.successTimer = FxTimer.runLater(SURVIVAL_THRESHOLD, this::timerComplete);
    }

    protected void removeTimer() {
        if (this.successTimer != null) {
            this.successTimer.stop();
            this.successTimer = null;
        }
    }

    protected void failed() {
        this.removeTimer();
    }

    public static class GameStartError
    extends RunGameError {
        GameStartError(Exception e) {
            this.initCause(e);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getCause()).toString();
        }
    }

    public static class GameExitError
    extends RunGameError {
        public final int exitValue;

        GameExitError(int exitValue) {
            this.exitValue = exitValue;
        }

        @Override
        public String getMessage() {
            return this.toString();
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("exitValue", this.exitValue).toString();
        }
    }

    public static class GameExitTooSoon
    extends RunGameError {
    }

    public static abstract class RunGameError
    extends Exception {
    }
}

