/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.animation.ScaleTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.game.GameManager;
import org.terasology.launcher.game.GameService;
import org.terasology.launcher.game.Installation;
import org.terasology.launcher.model.Build;
import org.terasology.launcher.model.GameIdentifier;
import org.terasology.launcher.model.GameRelease;
import org.terasology.launcher.model.Profile;
import org.terasology.launcher.repositories.RepositoryManager;
import org.terasology.launcher.settings.LauncherSettings;
import org.terasology.launcher.settings.Settings;
import org.terasology.launcher.tasks.DeleteTask;
import org.terasology.launcher.tasks.DownloadTask;
import org.terasology.launcher.ui.ChangelogViewController;
import org.terasology.launcher.ui.Dialogs;
import org.terasology.launcher.ui.Effects;
import org.terasology.launcher.ui.FooterController;
import org.terasology.launcher.ui.GameProfileCell;
import org.terasology.launcher.ui.GameReleaseCell;
import org.terasology.launcher.ui.LogViewController;
import org.terasology.launcher.ui.SettingsController;
import org.terasology.launcher.ui.Warning;
import org.terasology.launcher.util.BundleUtils;
import org.terasology.launcher.util.HostServices;
import org.terasology.launcher.util.Languages;

public class ApplicationController {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationController.class);
    private static final long MB = 0x100000L;
    private static final long MINIMUM_FREE_SPACE = 0xC800000L;
    private Path launcherDirectory;
    private LauncherSettings launcherSettings;
    private GameManager gameManager;
    private RepositoryManager repositoryManager;
    private final GameService gameService;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private DownloadTask downloadTask;
    private Stage stage;
    private Property<GameRelease> selectedRelease;
    private Property<GameAction> gameAction;
    private BooleanProperty downloading;
    private BooleanProperty showPreReleases;
    private ObservableSet<GameIdentifier> installedGames;
    private final Property<Optional<Warning>> warning = new SimpleObjectProperty(Optional.empty());
    @FXML
    private ComboBox<Profile> profileComboBox;
    @FXML
    private ComboBox<GameRelease> gameReleaseComboBox;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Button startButton;
    @FXML
    private Button downloadButton;
    @FXML
    private Button cancelDownloadButton;
    @FXML
    private Button deleteButton;
    @FXML
    private Button settingsButton;
    @FXML
    private Button exitButton;
    @FXML
    private LogViewController logViewController;
    @FXML
    private ChangelogViewController changelogViewController;
    @FXML
    private FooterController footerController;

    public ApplicationController() {
        this.gameService = new GameService();
        this.gameService.setOnFailed(this::handleRunFailed);
        this.gameService.valueProperty().addListener(this::handleRunStarted);
        this.downloading = new SimpleBooleanProperty(false);
        this.showPreReleases = new SimpleBooleanProperty(false);
        this.selectedRelease = new SimpleObjectProperty();
        this.installedGames = FXCollections.observableSet((Object[])new GameIdentifier[0]);
        this.gameAction = new SimpleObjectProperty((Object)GameAction.DOWNLOAD);
        this.gameAction.bind((ObservableValue)Bindings.createObjectBinding(() -> {
            boolean isInstalled;
            GameRelease release = (GameRelease)this.selectedRelease.getValue();
            boolean bl = isInstalled = release != null && this.installedGames.contains((Object)release.getId());
            if (this.downloading.get()) {
                return GameAction.CANCEL;
            }
            if (isInstalled) {
                return GameAction.PLAY;
            }
            return GameAction.DOWNLOAD;
        }, (Observable[])new Observable[]{this.selectedRelease, this.installedGames, this.downloading}));
    }

    @FXML
    public void initialize() {
        this.footerController.bind((ReadOnlyProperty<Optional<Warning>>)this.warning);
        this.initComboBoxes();
        this.initButtons();
    }

    private void initComboBoxes() {
        this.profileComboBox.setCellFactory(list -> new GameProfileCell());
        this.profileComboBox.setButtonCell((ListCell)new GameProfileCell());
        this.profileComboBox.setItems(FXCollections.observableList(Arrays.asList((Profile[])Profile.values().clone())));
        ReadOnlyObjectProperty selectedProfile = this.profileComboBox.getSelectionModel().selectedItemProperty();
        selectedProfile.addListener((obs, oldVal, newVal) -> {
            ObservableList availableReleases = this.gameReleaseComboBox.getItems();
            GameIdentifier lastPlayedGame = this.launcherSettings.getLastPlayedGameVersion().orElse(null);
            Optional<GameRelease> lastPlayed = availableReleases.stream().filter(release -> release.getId().equals(lastPlayedGame)).findFirst();
            Optional<GameRelease> lastInstalled = availableReleases.stream().filter(release -> this.installedGames.contains((Object)release.getId())).findFirst();
            this.gameReleaseComboBox.getSelectionModel().select((Object)lastPlayed.or(() -> lastInstalled).or(() -> availableReleases.stream().findFirst()).orElse(null));
        });
        ObjectBinding releases = Bindings.createObjectBinding(() -> {
            if (this.repositoryManager == null) {
                return FXCollections.emptyObservableList();
            }
            List releasesForProfile = this.repositoryManager.getReleases().stream().filter(release -> release.getId().getProfile() == selectedProfile.get()).filter(release -> this.showPreReleases.getValue() != false || release.getId().getBuild().equals((Object)Build.STABLE)).sorted(ApplicationController::compareReleases).collect(Collectors.toList());
            return FXCollections.observableList(releasesForProfile);
        }, (Observable[])new Observable[]{selectedProfile, this.showPreReleases});
        this.gameReleaseComboBox.itemsProperty().bind((ObservableValue)releases);
        this.gameReleaseComboBox.buttonCellProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new GameReleaseCell((Set<GameIdentifier>)this.installedGames, true), (Observable[])new Observable[]{this.installedGames}));
        this.gameReleaseComboBox.cellFactoryProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> list -> new GameReleaseCell((Set<GameIdentifier>)this.installedGames), (Observable[])new Observable[]{this.installedGames}));
        this.selectedRelease.bind((ObservableValue)this.gameReleaseComboBox.getSelectionModel().selectedItemProperty());
        this.selectedRelease.addListener((observable, oldValue, newValue) -> this.changelogViewController.update(newValue != null ? newValue.getChangelog() : ""));
    }

    private void initButtons() {
        this.cancelDownloadButton.setTooltip(new Tooltip(BundleUtils.getLabel("launcher_cancelDownload")));
        this.cancelDownloadButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.gameAction.getValue() == GameAction.CANCEL, (Observable[])new Observable[]{this.gameAction}));
        this.cancelDownloadButton.managedProperty().bind((ObservableValue)this.cancelDownloadButton.visibleProperty());
        this.startButton.setTooltip(new Tooltip(BundleUtils.getLabel("launcher_start")));
        this.startButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.gameAction.getValue() == GameAction.PLAY, (Observable[])new Observable[]{this.gameAction}));
        this.startButton.managedProperty().bind((ObservableValue)this.startButton.visibleProperty());
        this.downloadButton.setTooltip(new Tooltip(BundleUtils.getLabel("launcher_download")));
        this.downloadButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.gameAction.getValue() == GameAction.DOWNLOAD, (Observable[])new Observable[]{this.gameAction}));
        this.downloadButton.managedProperty().bind((ObservableValue)this.downloadButton.visibleProperty());
        this.deleteButton.setTooltip(new Tooltip(BundleUtils.getLabel("launcher_delete")));
        this.deleteButton.disableProperty().bind((ObservableValue)this.startButton.visibleProperty().not());
        this.settingsButton.setTooltip(new Tooltip(BundleUtils.getLabel("launcher_settings")));
        this.exitButton.setTooltip(new Tooltip(BundleUtils.getLabel("launcher_exit")));
    }

    public void update(Path launcherDirectory, Path downloadDirectory, LauncherSettings launcherSettings, RepositoryManager repositoryManager, GameManager gameManager, Stage stage, HostServices hostServices) {
        this.launcherDirectory = launcherDirectory;
        this.launcherSettings = launcherSettings;
        this.showPreReleases.bind(launcherSettings.showPreReleases());
        this.repositoryManager = repositoryManager;
        this.gameManager = gameManager;
        this.stage = stage;
        Bindings.bindContent(this.installedGames, gameManager.getInstalledGames());
        this.profileComboBox.getSelectionModel().select((Object)launcherSettings.getLastPlayedGameVersion().map(GameIdentifier::getProfile).orElse(Profile.OMEGA));
        Logger rootLogger = LoggerFactory.getLogger("ROOT");
        if (rootLogger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)rootLogger;
            this.logViewController.setContext((Context)logbackLogger.getLoggerContext());
            this.logViewController.start();
            logbackLogger.addAppender((Appender<ILoggingEvent>)this.logViewController);
        }
        if (downloadDirectory.toFile().getUsableSpace() <= 0xC800000L) {
            this.warning.setValue(Optional.of(Warning.LOW_ON_SPACE));
        } else {
            this.warning.setValue(Optional.empty());
        }
        this.footerController.setHostServices(hostServices);
    }

    @FXML
    protected void handleExitButtonAction() {
        this.close();
    }

    @FXML
    protected void handleControlButtonMouseEntered(MouseEvent event) {
        Node source = (Node)event.getSource();
        ScaleTransition t = Effects.createScaleTransition(1.2, source);
        t.playFromStart();
    }

    @FXML
    protected void handleControlButtonMouseExited(MouseEvent event) {
        Node source = (Node)event.getSource();
        ScaleTransition t = Effects.createScaleTransition(1.0, source);
        t.playFromStart();
    }

    @FXML
    protected void openSettingsAction() {
        try {
            Parent root;
            FXMLLoader fxmlLoader;
            logger.info("Current Locale: {}", (Object)Languages.getCurrentLocale());
            Stage settingsStage = new Stage(StageStyle.UNDECORATED);
            settingsStage.initModality(Modality.APPLICATION_MODAL);
            try {
                fxmlLoader = BundleUtils.getFXMLLoader("settings");
                root = (Parent)fxmlLoader.load();
            }
            catch (IOException e) {
                fxmlLoader = BundleUtils.getFXMLLoader("settings");
                fxmlLoader.setResources(ResourceBundle.getBundle("org.terasology.launcher.bundle.LabelsBundle", Languages.DEFAULT_LOCALE));
                root = (Parent)fxmlLoader.load();
            }
            SettingsController settingsController = (SettingsController)fxmlLoader.getController();
            settingsController.initialize(this.launcherDirectory, this.launcherSettings, settingsStage, this);
            Scene scene = new Scene(root);
            settingsStage.setScene(scene);
            settingsStage.showAndWait();
        }
        catch (IOException e) {
            logger.warn("Exception in openSettingsAction: ", e);
        }
    }

    @FXML
    protected void startGameAction() {
        Installation installation;
        if (this.gameService.isRunning()) {
            logger.debug("The game can not be started because another game is already running.");
            Dialogs.showInfo(this.stage, BundleUtils.getLabel("message_information_gameRunning"));
            return;
        }
        GameRelease release = (GameRelease)this.selectedRelease.getValue();
        try {
            installation = this.gameManager.getInstallation(release.getId());
        }
        catch (FileNotFoundException e) {
            logger.warn("Failed to get an installation for selection {}", (Object)release, (Object)e);
            Dialogs.showError(this.stage, BundleUtils.getMessage("message_error_installationNotFound", release));
            return;
        }
        this.gameService.start(installation, this.launcherSettings);
    }

    private void handleRunStarted(ObservableValue<? extends Boolean> o, Boolean oldValue, Boolean newValue) {
        if (newValue == null || !newValue.booleanValue()) {
            return;
        }
        logger.debug("Game has started successfully.");
        this.launcherSettings.setLastPlayedGameVersion(((GameRelease)this.selectedRelease.getValue()).getId());
        if (this.launcherSettings.isCloseLauncherAfterGameStart()) {
            if (this.downloadTask == null) {
                logger.info("Close launcher after game start.");
                this.close();
            } else {
                logger.info("The launcher can not be closed after game start, because a download is running.");
            }
        }
    }

    void handleRunFailed(WorkerStateEvent event) {
        TabPane tabPane = (TabPane)this.stage.getScene().lookup("#contentTabPane");
        if (tabPane != null) {
            Node tab = tabPane.lookup("#logTab");
            tabPane.getSelectionModel().select((Object)((Tab)tab.getProperties().get(Tab.class)));
        } else {
            logger.warn("Failed to locate tab pane.");
        }
        Dialogs.showError(this.stage, BundleUtils.getLabel("message_error_gameStart"));
    }

    @FXML
    protected void downloadAction() {
        this.downloadTask = new DownloadTask(this.gameManager, (GameRelease)this.selectedRelease.getValue());
        this.downloading.bind((ObservableValue)this.downloadTask.runningProperty());
        this.profileComboBox.disableProperty().bind((ObservableValue)this.downloadTask.runningProperty());
        this.gameReleaseComboBox.disableProperty().bind((ObservableValue)this.downloadTask.runningProperty());
        this.progressBar.visibleProperty().bind((ObservableValue)this.downloadTask.runningProperty());
        this.progressBar.progressProperty().bind((ObservableValue)this.downloadTask.progressProperty());
        this.downloadTask.setOnSucceeded(workerStateEvent -> {
            this.downloadTask = null;
        });
        this.executor.submit((Runnable)((Object)this.downloadTask));
    }

    @FXML
    protected void cancelDownloadAction() {
        logger.info("Cancel game download!");
        this.downloadTask.cancel(false);
    }

    @FXML
    protected void deleteAction() {
        GameIdentifier id = ((GameRelease)this.selectedRelease.getValue()).getId();
        Path gameDir = this.gameManager.getInstallDirectory(id);
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setContentText(BundleUtils.getMessage("confirmDeleteGame_withoutData", gameDir));
        alert.setTitle(BundleUtils.getLabel("message_deleteGame_title"));
        alert.initOwner((Window)this.stage);
        alert.showAndWait().filter(response -> response == ButtonType.OK).ifPresent(response -> {
            logger.info("Removing game '{}' from path '{}", (Object)id, (Object)gameDir);
            this.launcherSettings.setLastPlayedGameVersion(null);
            DeleteTask deleteTask = new DeleteTask(this.gameManager, id);
            this.executor.submit((Runnable)((Object)deleteTask));
        });
    }

    private <T> void selectItem(ComboBox<T> comboBox, Predicate<T> predicate) {
        Object item = comboBox.getItems().stream().filter(predicate).findFirst().orElse(comboBox.getItems().get(0));
        comboBox.getSelectionModel().select(item);
    }

    private void close() {
        logger.debug("Dispose launcher frame...");
        Path settingsFile = this.launcherDirectory.resolve("TerasologyLauncherSettings.properties");
        try {
            Settings.store(this.launcherSettings, settingsFile);
        }
        catch (IOException e) {
            logger.warn("Could not store current launcher settings!");
        }
        if (this.downloadTask != null) {
            this.downloadTask.cancel(true);
        }
        this.executor.shutdownNow();
        logger.debug("Closing the launcher ...");
        this.stage.close();
    }

    private static int compareReleases(GameRelease o1, GameRelease o2) {
        int compareProfile = o1.getId().getProfile().compareTo(o2.getId().getProfile());
        if (compareProfile != 0) {
            return compareProfile;
        }
        return o2.getTimestamp().compareTo(o1.getTimestamp());
    }

    private static enum GameAction {
        PLAY,
        DOWNLOAD,
        CANCEL;

    }
}

