/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util;

public final class Platform {
    private static final Platform PLATFORM = new Platform();
    private String os;
    private String arch;

    private Platform() {
        String platformOs = System.getProperty("os.name").toLowerCase();
        this.os = platformOs.startsWith("linux") ? "linux" : (platformOs.startsWith("mac os") ? "mac" : (platformOs.startsWith("windows") ? "windows" : platformOs));
        String platformArch = System.getProperty("os.arch");
        this.arch = platformArch.equals("x86_64") || platformArch.equals("amd64") ? "64" : (platformArch.equals("x86") || platformArch.equals("i386") ? "32" : platformArch);
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean isLinux() {
        return this.os.equals("linux");
    }

    public boolean isMac() {
        return this.os.equals("mac");
    }

    public boolean isWindows() {
        return this.os.equals("windows");
    }

    public String toString() {
        return "OS '" + this.os + "', arch '" + this.arch + "'";
    }

    public static Platform getPlatform() {
        return PLATFORM;
    }
}

