/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.modifiers;

import com.ibm.icu.impl.StandardPlural;
import com.ibm.icu.impl.number.Format;
import com.ibm.icu.impl.number.FormatQuantity;
import com.ibm.icu.impl.number.Modifier;
import com.ibm.icu.impl.number.ModifierHolder;
import com.ibm.icu.impl.number.Properties;
import com.ibm.icu.impl.number.modifiers.PositiveNegativeAffixModifier;
import com.ibm.icu.text.PluralRules;

public class GeneralPluralModifier
extends Format.BeforeFormat
implements Modifier.PositiveNegativePluralModifier {
    private final Modifier[] mods = new Modifier[StandardPlural.COUNT * 2];

    public void put(StandardPlural plural, Modifier modifier) {
        this.put(plural, modifier, modifier);
    }

    public void put(StandardPlural plural, Modifier positive, Modifier negative) {
        assert (this.mods[plural.ordinal() * 2] == null);
        assert (this.mods[plural.ordinal() * 2 + 1] == null);
        assert (positive != null);
        assert (negative != null);
        this.mods[plural.ordinal() * 2] = positive;
        this.mods[plural.ordinal() * 2 + 1] = negative;
    }

    @Override
    public Modifier getModifier(StandardPlural plural, boolean isNegative) {
        Modifier mod = this.mods[plural.ordinal() * 2 + (isNegative ? 1 : 0)];
        if (mod == null) {
            mod = this.mods[StandardPlural.OTHER.ordinal() * 2 + (isNegative ? 1 : 0)];
        }
        if (mod == null) {
            throw new UnsupportedOperationException();
        }
        return mod;
    }

    @Override
    public void before(FormatQuantity input, ModifierHolder mods, PluralRules rules) {
        mods.add(this.getModifier(input.getStandardPlural(rules), input.isNegative()));
    }

    @Override
    public void before(FormatQuantity input, ModifierHolder mods) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void export(Properties properties) {
        Modifier positive = this.getModifier(StandardPlural.OTHER, false);
        Modifier negative = this.getModifier(StandardPlural.OTHER, true);
        PositiveNegativeAffixModifier.exportPositiveNegative(properties, positive, negative);
    }
}

