/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.model;

import com.google.common.io.Resources;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LauncherVersion {
    private static final Logger logger = LoggerFactory.getLogger(LauncherVersion.class);
    private static final String VERSION_INFO_FILE = "/org/terasology/launcher/version.txt";
    private static LauncherVersion instance;
    private final Semver semver;

    private LauncherVersion(Semver semver) {
        this.semver = semver;
    }

    public static synchronized LauncherVersion getInstance() {
        if (instance == null) {
            String version = "";
            Semver semver = null;
            try {
                version = Resources.toString((URL)Resources.getResource(LauncherVersion.class, (String)VERSION_INFO_FILE), (Charset)StandardCharsets.UTF_8);
                semver = new Semver(version);
            }
            catch (SemverException e) {
                logger.error("Failed to load launcher version info from '{}': Invalid semver '{}'.", new Object[]{VERSION_INFO_FILE, version, e});
            }
            catch (IOException e) {
                logger.error("Loading launcher version info from '{}' failed.", (Object)VERSION_INFO_FILE, (Object)e);
            }
            instance = new LauncherVersion(semver);
        }
        return instance;
    }

    public String getDisplayName() {
        return Optional.ofNullable(this.semver).map(Semver::getValue).orElse("n/a");
    }

    public Semver getSemver() {
        return this.semver;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

