/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.repositories;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.model.Build;
import org.terasology.launcher.model.GameIdentifier;
import org.terasology.launcher.model.GameRelease;
import org.terasology.launcher.model.Profile;
import org.terasology.launcher.model.ReleaseMetadata;
import org.terasology.launcher.repositories.ReleaseRepository;

public class GithubRepositoryAdapter
implements ReleaseRepository {
    private static final Logger logger = LoggerFactory.getLogger(GithubRepositoryAdapter.class);
    private GitHub github;

    public GithubRepositoryAdapter() {
        try {
            this.github = GitHub.connectAnonymously();
            logger.debug("Github rate limit: {}", (Object)this.github.getRateLimit());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static GameRelease fromGithubRelease(GHRelease ghRelease) {
        Profile profile = Profile.OMEGA;
        Build build = ghRelease.isPrerelease() ? Build.NIGHTLY : Build.STABLE;
        String tagName = ghRelease.getTagName();
        try {
            Semver engineVersion = tagName.startsWith("v") ? new Semver(tagName.substring(1)) : new Semver(tagName);
            Optional<GHAsset> gameAsset = ghRelease.assets().stream().filter(asset -> asset.getName().matches("Terasology.*zip")).findFirst();
            URL url = new URL(gameAsset.map(GHAsset::getBrowserDownloadUrl).orElseThrow(() -> new IOException("Missing game asset.")));
            String changelog = ghRelease.getBody();
            GameIdentifier id = new GameIdentifier(engineVersion.toString(), build, profile);
            ReleaseMetadata metadata = new ReleaseMetadata(changelog, ghRelease.getPublished_at());
            return new GameRelease(id, url, metadata);
        }
        catch (SemverException | IOException e) {
            logger.info("Could not create game release from Github release {}: {}", (Object)ghRelease.getHtmlUrl(), (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public List<GameRelease> fetchReleases() {
        if (this.github != null) {
            try {
                GHRepository repository = this.github.getRepository("MovingBlocks/Terasology");
                List githubReleases = repository.listReleases().toList();
                List<GameRelease> releases = githubReleases.stream().map(GithubRepositoryAdapter::fromGithubRelease).filter(Objects::nonNull).collect(Collectors.toList());
                logger.debug("Github rate limit: {}", (Object)this.github.getRateLimit());
                return releases;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyList();
    }
}

