/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.repositories;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.repositories.Jenkins;

class JenkinsClient {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsClient.class);
    private static final String ARTIFACT = "artifact/";
    private final Gson gson;

    JenkinsClient(Gson gson) {
        this.gson = gson;
    }

    static InputStream openStream(URL url) throws IOException, URISyntaxException, InterruptedException {
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest request = HttpRequest.newBuilder(url.toURI()).build();
        HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        logger.debug("{}", (Object)response);
        return response.body();
    }

    Jenkins.ApiResult request(URL url) throws InterruptedException {
        block8: {
            Jenkins.ApiResult apiResult;
            Preconditions.checkNotNull((Object)url);
            BufferedReader reader = new BufferedReader(new InputStreamReader(JenkinsClient.openStream(url)));
            try {
                apiResult = (Jenkins.ApiResult)this.gson.fromJson((Reader)reader, Jenkins.ApiResult.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    logger.warn("Failed to read JSON from '{}'", (Object)url.toExternalForm(), (Object)e);
                    break block8;
                }
                catch (IOException | URISyntaxException e) {
                    logger.warn("Failed to read from URL '{}'\n\t{}", (Object)url.toExternalForm(), (Object)e.getMessage());
                }
            }
            reader.close();
            return apiResult;
        }
        return null;
    }

    @Nullable Properties requestProperties(URL artifactUrl) {
        Properties properties;
        block8: {
            Preconditions.checkNotNull((Object)artifactUrl);
            InputStream inputStream = JenkinsClient.openStream(artifactUrl);
            try {
                Properties properties2 = new Properties();
                properties2.load(inputStream);
                properties = properties2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException | URISyntaxException e) {
                    logger.warn("Error while fetching {}", (Object)artifactUrl, (Object)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return properties;
    }

    @Nullable URL getArtifactUrl(Jenkins.Build build, String regex) {
        if (build.artifacts == null || build.url == null) {
            return null;
        }
        Optional<String> url = Arrays.stream(build.artifacts).filter(artifact -> artifact.fileName.matches(regex)).findFirst().map(artifact -> build.url + ARTIFACT + artifact.relativePath);
        if (url.isPresent()) {
            try {
                return new URL(url.get());
            }
            catch (MalformedURLException e) {
                logger.debug("Invalid URL: '{}'", (Object)url, (Object)e);
            }
        }
        return null;
    }
}

