/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.settings;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.terasology.launcher.model.GameIdentifier;
import org.terasology.launcher.settings.LauncherSettings;
import org.terasology.launcher.util.JavaHeapSize;
import org.terasology.launcher.util.Languages;

public final class BaseLauncherSettings
extends LauncherSettings {
    public static final String USER_JAVA_PARAMETERS_DEFAULT = "-XX:MaxGCPauseMillis=20";
    public static final String USER_GAME_PARAMETERS_DEFAULT = "";
    public static final String PROPERTY_LOCALE = "locale";
    public static final String PROPERTY_MAX_HEAP_SIZE = "maxHeapSize";
    public static final String PROPERTY_INITIAL_HEAP_SIZE = "initialHeapSize";
    public static final String PROPERTY_CLOSE_LAUNCHER_AFTER_GAME_START = "closeLauncherAfterGameStart";
    public static final String PROPERTY_GAME_DIRECTORY = "gameDirectory";
    public static final String PROPERTY_GAME_DATA_DIRECTORY = "gameDataDirectory";
    public static final String PROPERTY_SAVE_DOWNLOADED_FILES = "saveDownloadedFiles";
    public static final String PROPERTY_SHOW_PRE_RELEASES = "showPreReleases";
    public static final String PROPERTY_BASE_JAVA_PARAMETERS = "baseJavaParameters";
    public static final String PROPERTY_USER_JAVA_PARAMETERS = "userJavaParameters";
    public static final String PROPERTY_USER_GAME_PARAMETERS = "userGameParameters";
    public static final String PROPERTY_LOG_LEVEL = "logLevel";
    public static final String PROPERTY_DEFAULT_GAME_JOB = "defaultGameJob";
    public static final String PROPERTY_LAST_PLAYED_GAME_VERSION = "lastPlayedGameVersion";
    public static final String PROPERTY_LAST_INSTALLED_GAME_JOB = "lastInstalledGameJob";
    public static final String PROPERTY_LAST_INSTALLED_GAME_VERSION = "lastInstalledGameVersion";
    public static final JavaHeapSize MAX_HEAP_SIZE_DEFAULT = JavaHeapSize.NOT_USED;
    public static final JavaHeapSize INITIAL_HEAP_SIZE_DEFAULT = JavaHeapSize.NOT_USED;
    public static final boolean CLOSE_LAUNCHER_AFTER_GAME_START_DEFAULT = true;
    public static final boolean SAVE_DOWNLOADED_FILES_DEFAULT = false;
    public static final boolean SHOW_PRE_RELEASES_DEFAULT = false;
    public static final String LAST_PLAYED_GAME_VERSION_DEFAULT = "";
    public static final String LAST_INSTALLED_GAME_VERSION_DEFAULT = "";
    public static final String LAUNCHER_SETTINGS_FILE_NAME = "TerasologyLauncherSettings.properties";
    private static final Logger logger = LoggerFactory.getLogger(BaseLauncherSettings.class);
    private static final String WARN_MSG_INVALID_VALUE = "Invalid value '{}' for the parameter '{}'!";
    private static final Level LOG_LEVEL_DEFAULT = Level.INFO;
    private final Properties properties;
    private final Property<Boolean> showPreReleases = new SimpleBooleanProperty(false);

    BaseLauncherSettings(Properties properties) {
        this.properties = properties;
    }

    @Override
    Properties getProperties() {
        return this.properties;
    }

    @Override
    protected void initLocale() {
        String localeStr = this.properties.getProperty(PROPERTY_LOCALE);
        if (localeStr != null) {
            Languages.init(localeStr);
            if (!Languages.getCurrentLocale().toString().equals(localeStr)) {
                logger.warn(WARN_MSG_INVALID_VALUE, (Object)localeStr, (Object)PROPERTY_LOCALE);
            }
        }
        this.properties.setProperty(PROPERTY_LOCALE, Languages.getCurrentLocale().toString());
    }

    @Override
    protected void initMaxHeapSize() {
        String maxHeapSizeStr = this.properties.getProperty(PROPERTY_MAX_HEAP_SIZE);
        JavaHeapSize maxJavaHeapSize = MAX_HEAP_SIZE_DEFAULT;
        if (maxHeapSizeStr != null) {
            try {
                maxJavaHeapSize = JavaHeapSize.valueOf(maxHeapSizeStr);
            }
            catch (IllegalArgumentException e) {
                logger.warn(WARN_MSG_INVALID_VALUE, (Object)maxHeapSizeStr, (Object)PROPERTY_MAX_HEAP_SIZE);
            }
        }
        this.properties.setProperty(PROPERTY_MAX_HEAP_SIZE, maxJavaHeapSize.name());
    }

    @Override
    protected void initInitialHeapSize() {
        String initialHeapSizeStr = this.properties.getProperty(PROPERTY_INITIAL_HEAP_SIZE);
        JavaHeapSize initialJavaHeapSize = INITIAL_HEAP_SIZE_DEFAULT;
        if (initialHeapSizeStr != null) {
            try {
                initialJavaHeapSize = JavaHeapSize.valueOf(initialHeapSizeStr);
            }
            catch (IllegalArgumentException e) {
                logger.warn(WARN_MSG_INVALID_VALUE, (Object)initialHeapSizeStr, (Object)PROPERTY_INITIAL_HEAP_SIZE);
            }
        }
        this.properties.setProperty(PROPERTY_INITIAL_HEAP_SIZE, initialJavaHeapSize.name());
    }

    @Override
    protected void initBaseJavaParameters() {
    }

    @Override
    protected void initUserJavaParameters() {
        String userJavaParsStr = this.properties.getProperty(PROPERTY_USER_JAVA_PARAMETERS);
        if (userJavaParsStr == null || userJavaParsStr.isEmpty()) {
            this.properties.setProperty(PROPERTY_USER_JAVA_PARAMETERS, USER_JAVA_PARAMETERS_DEFAULT);
        }
    }

    @Override
    protected void initUserGameParameters() {
        String userJavaParsStr = this.properties.getProperty(PROPERTY_USER_GAME_PARAMETERS);
        if (userJavaParsStr == null || userJavaParsStr.isEmpty()) {
            this.properties.setProperty(PROPERTY_USER_GAME_PARAMETERS, "");
        }
    }

    @Override
    protected void initLogLevel() {
        String logLevelStr = this.properties.getProperty(PROPERTY_LOG_LEVEL);
        Level logLevel = LOG_LEVEL_DEFAULT;
        if (logLevelStr != null) {
            try {
                logLevel = Level.valueOf(logLevelStr);
            }
            catch (IllegalArgumentException e) {
                logger.warn(WARN_MSG_INVALID_VALUE, (Object)logLevelStr, (Object)PROPERTY_LOG_LEVEL);
            }
        }
        this.properties.setProperty(PROPERTY_LOG_LEVEL, logLevel.name());
    }

    @Override
    protected void initCloseLauncherAfterGameStart() {
        String closeLauncherAfterGameStartStr = this.properties.getProperty(PROPERTY_CLOSE_LAUNCHER_AFTER_GAME_START);
        boolean closeLauncherAfterGameStart = true;
        if (closeLauncherAfterGameStartStr != null) {
            closeLauncherAfterGameStart = Boolean.valueOf(closeLauncherAfterGameStartStr);
        }
        this.properties.setProperty(PROPERTY_CLOSE_LAUNCHER_AFTER_GAME_START, Boolean.toString(closeLauncherAfterGameStart));
    }

    @Override
    protected void initSaveDownloadedFiles() {
        String saveDownloadedFilesStr = this.properties.getProperty(PROPERTY_SAVE_DOWNLOADED_FILES);
        boolean saveDownloadedFiles = false;
        if (saveDownloadedFilesStr != null) {
            saveDownloadedFiles = Boolean.valueOf(saveDownloadedFilesStr);
        }
        this.properties.setProperty(PROPERTY_SAVE_DOWNLOADED_FILES, Boolean.toString(saveDownloadedFiles));
    }

    @Override
    protected void initShowPreReleases() {
        String showPreReleasesStr = this.properties.getProperty(PROPERTY_SHOW_PRE_RELEASES);
        if (showPreReleasesStr != null) {
            this.setShowPreReleases(Boolean.parseBoolean(showPreReleasesStr));
        } else {
            this.setShowPreReleases(false);
        }
    }

    @Override
    protected void initGameDirectory() {
        String gameDirectoryStr = this.properties.getProperty(PROPERTY_GAME_DIRECTORY);
        Path gameDirectory = null;
        if (gameDirectoryStr != null && gameDirectoryStr.trim().length() > 0) {
            try {
                gameDirectory = Paths.get(new URI(gameDirectoryStr));
            }
            catch (RuntimeException | URISyntaxException e) {
                logger.warn(WARN_MSG_INVALID_VALUE, (Object)gameDirectoryStr, (Object)PROPERTY_GAME_DIRECTORY);
            }
        }
        if (gameDirectory != null) {
            this.properties.setProperty(PROPERTY_GAME_DIRECTORY, gameDirectory.toUri().toString());
        } else {
            this.properties.setProperty(PROPERTY_GAME_DIRECTORY, "");
        }
    }

    @Override
    protected void initGameDataDirectory() {
        String gameDataDirectoryStr = this.properties.getProperty(PROPERTY_GAME_DATA_DIRECTORY);
        Path gameDataDirectory = null;
        if (gameDataDirectoryStr != null && gameDataDirectoryStr.trim().length() > 0) {
            try {
                gameDataDirectory = Paths.get(new URI(gameDataDirectoryStr));
            }
            catch (RuntimeException | URISyntaxException e) {
                logger.warn(WARN_MSG_INVALID_VALUE, (Object)gameDataDirectoryStr, (Object)PROPERTY_GAME_DATA_DIRECTORY);
            }
        }
        if (gameDataDirectory != null) {
            this.properties.setProperty(PROPERTY_GAME_DATA_DIRECTORY, gameDataDirectory.toUri().toString());
        } else {
            this.properties.setProperty(PROPERTY_GAME_DATA_DIRECTORY, "");
        }
    }

    @Override
    protected void initLastPlayedGameVersion() {
        String lastPlayedGameVersionStr = this.properties.getProperty(PROPERTY_LAST_PLAYED_GAME_VERSION);
        if (lastPlayedGameVersionStr == null || lastPlayedGameVersionStr.isEmpty()) {
            this.properties.setProperty(PROPERTY_LAST_PLAYED_GAME_VERSION, "");
        }
    }

    @Override
    protected void initLastInstalledGameVersion() {
        String lastInstalledGameVersionStr = this.properties.getProperty(PROPERTY_LAST_INSTALLED_GAME_VERSION);
        if (lastInstalledGameVersionStr == null || lastInstalledGameVersionStr.isEmpty()) {
            this.properties.setProperty(PROPERTY_LAST_INSTALLED_GAME_VERSION, "");
        }
    }

    @Override
    public ReadOnlyProperty<Boolean> showPreReleases() {
        return this.showPreReleases;
    }

    @Override
    public synchronized Locale getLocale() {
        return Locale.forLanguageTag(this.properties.getProperty(PROPERTY_LOCALE));
    }

    @Override
    public synchronized JavaHeapSize getMaxHeapSize() {
        return JavaHeapSize.valueOf(this.properties.getProperty(PROPERTY_MAX_HEAP_SIZE));
    }

    @Override
    public synchronized JavaHeapSize getInitialHeapSize() {
        return JavaHeapSize.valueOf(this.properties.getProperty(PROPERTY_INITIAL_HEAP_SIZE));
    }

    @Override
    public synchronized String getBaseJavaParameters() {
        return this.properties.getProperty(PROPERTY_BASE_JAVA_PARAMETERS);
    }

    @Override
    public synchronized String getUserJavaParameters() {
        return this.properties.getProperty(PROPERTY_USER_JAVA_PARAMETERS);
    }

    @Override
    public synchronized String getUserGameParameters() {
        return this.properties.getProperty(PROPERTY_USER_GAME_PARAMETERS);
    }

    @Override
    public synchronized Level getLogLevel() {
        return Level.valueOf(this.properties.getProperty(PROPERTY_LOG_LEVEL));
    }

    @Override
    public synchronized Path getGameDirectory() {
        String gameDirectoryStr = this.properties.getProperty(PROPERTY_GAME_DIRECTORY);
        if (gameDirectoryStr != null && gameDirectoryStr.trim().length() > 0) {
            try {
                return Paths.get(new URI(gameDirectoryStr));
            }
            catch (RuntimeException | URISyntaxException e) {
                logger.error(WARN_MSG_INVALID_VALUE, (Object)gameDirectoryStr, (Object)PROPERTY_GAME_DIRECTORY);
            }
        }
        return null;
    }

    @Override
    public synchronized Path getGameDataDirectory() {
        String gameDataDirectoryStr = this.properties.getProperty(PROPERTY_GAME_DATA_DIRECTORY);
        if (gameDataDirectoryStr != null && gameDataDirectoryStr.trim().length() > 0) {
            try {
                return Paths.get(new URI(gameDataDirectoryStr));
            }
            catch (RuntimeException | URISyntaxException e) {
                logger.error(WARN_MSG_INVALID_VALUE, (Object)gameDataDirectoryStr, (Object)PROPERTY_GAME_DATA_DIRECTORY);
            }
        }
        return null;
    }

    @Override
    public synchronized boolean isCloseLauncherAfterGameStart() {
        return Boolean.valueOf(this.properties.getProperty(PROPERTY_CLOSE_LAUNCHER_AFTER_GAME_START));
    }

    @Override
    public synchronized boolean isKeepDownloadedFiles() {
        return Boolean.valueOf(this.properties.getProperty(PROPERTY_SAVE_DOWNLOADED_FILES));
    }

    @Override
    public synchronized boolean isShowPreReleases() {
        return Boolean.parseBoolean(this.properties.getProperty(PROPERTY_SHOW_PRE_RELEASES));
    }

    @Override
    public synchronized Optional<GameIdentifier> getLastPlayedGameVersion() {
        GameIdentifier id;
        String property = this.properties.getProperty(PROPERTY_LAST_PLAYED_GAME_VERSION);
        if (property == null || property.isEmpty()) {
            return Optional.empty();
        }
        try {
            id = (GameIdentifier)new Gson().fromJson(property, GameIdentifier.class);
        }
        catch (JsonParseException e) {
            logger.warn("Failed to parse a game version from \"{}\". This should automatically resolve when starting a game.", (Object)property, (Object)e);
            return Optional.empty();
        }
        return Optional.ofNullable(id);
    }

    @Override
    public synchronized String getLastInstalledGameJob() {
        return this.properties.getProperty(PROPERTY_LAST_INSTALLED_GAME_JOB);
    }

    @Override
    public synchronized void setLocale(Locale locale) {
        this.properties.setProperty(PROPERTY_LOCALE, locale.toString());
    }

    @Override
    public synchronized void setMaxHeapSize(JavaHeapSize maxHeapSize) {
        this.properties.setProperty(PROPERTY_MAX_HEAP_SIZE, maxHeapSize.name());
    }

    @Override
    public synchronized void setInitialHeapSize(JavaHeapSize initialHeapSize) {
        this.properties.setProperty(PROPERTY_INITIAL_HEAP_SIZE, initialHeapSize.name());
    }

    @Override
    public synchronized void setUserJavaParameters(String userJavaParameters) {
        this.properties.setProperty(PROPERTY_USER_JAVA_PARAMETERS, userJavaParameters);
    }

    @Override
    public synchronized void setUserGameParameters(String userGameParameters) {
        this.properties.setProperty(PROPERTY_USER_GAME_PARAMETERS, userGameParameters);
    }

    @Override
    public synchronized void setLogLevel(Level logLevel) {
        this.properties.setProperty(PROPERTY_LOG_LEVEL, logLevel.name());
    }

    @Override
    public synchronized void setCloseLauncherAfterGameStart(boolean closeLauncherAfterGameStart) {
        this.properties.setProperty(PROPERTY_CLOSE_LAUNCHER_AFTER_GAME_START, Boolean.toString(closeLauncherAfterGameStart));
    }

    @Override
    public synchronized void setKeepDownloadedFiles(boolean keepDownloadedFiles) {
        this.properties.setProperty(PROPERTY_SAVE_DOWNLOADED_FILES, Boolean.toString(keepDownloadedFiles));
    }

    @Override
    public synchronized void setShowPreReleases(boolean selected) {
        this.showPreReleases.setValue((Object)selected);
        this.properties.setProperty(PROPERTY_SHOW_PRE_RELEASES, Boolean.toString(selected));
    }

    @Override
    public synchronized void setGameDirectory(Path gameDirectory) {
        this.properties.setProperty(PROPERTY_GAME_DIRECTORY, gameDirectory.toUri().toString());
    }

    @Override
    public synchronized void setGameDataDirectory(Path gameDataDirectory) {
        this.properties.setProperty(PROPERTY_GAME_DATA_DIRECTORY, gameDataDirectory.toUri().toString());
    }

    @Override
    public synchronized void setDefaultGameJob(String defaultGameJob) {
        this.properties.setProperty(PROPERTY_DEFAULT_GAME_JOB, defaultGameJob);
    }

    @Override
    public synchronized void setLastPlayedGameVersion(GameIdentifier lastPlayedGameVersion) {
        if (lastPlayedGameVersion == null) {
            this.properties.setProperty(PROPERTY_LAST_PLAYED_GAME_VERSION, "");
        } else {
            this.properties.setProperty(PROPERTY_LAST_PLAYED_GAME_VERSION, new Gson().toJson((Object)lastPlayedGameVersion));
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.properties.toString() + "]";
    }
}

