/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.util.BundleUtils;
import org.terasology.launcher.util.FileUtils;
import org.terasology.launcher.util.LauncherDirectoryUtils;

public final class Dialogs {
    private static final Logger logger = LoggerFactory.getLogger(Dialogs.class);

    private Dialogs() {
    }

    private static <T> T runOnEventThread(final Supplier<T> producer) {
        Object result = null;
        if (Platform.isFxApplicationThread()) {
            result = producer.get();
        } else {
            Task task = new Task<T>(){

                protected T call() throws Exception {
                    return producer.get();
                }
            };
            Platform.runLater((Runnable)task);
            try {
                result = task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.warn("Uh oh, something went wrong running this on the event thread.", e);
            }
        }
        return (T)result;
    }

    private static void showMessageDialog(Alert.AlertType type, String title, String message, Stage owner) {
        Dialogs.runOnEventThread(() -> {
            Alert alert = new Alert(type);
            alert.setTitle(title);
            alert.setContentText(message);
            alert.initOwner((Window)owner);
            alert.showAndWait();
            return null;
        });
    }

    public static void showWarning(Stage owner, String message) {
        Dialogs.showMessageDialog(Alert.AlertType.WARNING, BundleUtils.getLabel("message_error_title"), message, owner);
    }

    public static void showError(Stage owner, String message) {
        Dialogs.showMessageDialog(Alert.AlertType.ERROR, BundleUtils.getLabel("message_error_title"), message, owner);
    }

    public static void showInfo(Stage owner, String message) {
        Dialogs.showMessageDialog(Alert.AlertType.INFORMATION, BundleUtils.getLabel("message_information_title"), message, owner);
    }

    public static Path chooseDirectory(Stage owner, Path defaultDirectory, String title) {
        try {
            FileUtils.ensureWritableDir(defaultDirectory);
        }
        catch (IOException e) {
            logger.error("Could not use {} as default directory!", (Object)defaultDirectory, (Object)e);
            return null;
        }
        Path selected = Dialogs.runOnEventThread(() -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setInitialDirectory(defaultDirectory.toFile());
            directoryChooser.setTitle(title);
            return Optional.ofNullable(directoryChooser.showDialog((Window)owner)).map(File::toPath).orElse(null);
        });
        try {
            if (Dialogs.deleteProposedDirectoryIfUnused(defaultDirectory, selected)) {
                logger.warn("Could not delete unused default directory! {}", (Object)defaultDirectory);
            }
        }
        catch (IOException e) {
            logger.error("Failed to delete unused default directory! {}", (Object)defaultDirectory, (Object)e);
        }
        return selected;
    }

    private static boolean deleteProposedDirectoryIfUnused(Path proposed, Path selected) throws IOException {
        return selected != null && !Files.isSameFile(proposed, selected) && !LauncherDirectoryUtils.containsFiles(proposed) && !Files.deleteIfExists(proposed);
    }

    public static void openFileBrowser(Stage owner, Path directory, String errorMsg) {
        try {
            FileUtils.ensureWritableDir(directory);
            EventQueue.invokeLater(() -> {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(directory.toFile());
                    }
                    catch (IOException e) {
                        logger.error("The directory could not be opened! {}", (Object)directory, (Object)e);
                        Dialogs.showError(owner, errorMsg + "\n" + directory);
                    }
                }
            });
        }
        catch (IOException e) {
            logger.error("The directory could not be opened! {}", (Object)directory, (Object)e);
            Dialogs.showError(owner, errorMsg + "\n" + directory);
        }
    }
}

