/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import java.util.Optional;
import javafx.animation.ScaleTransition;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.model.LauncherVersion;
import org.terasology.launcher.ui.Effects;
import org.terasology.launcher.ui.Warning;
import org.terasology.launcher.util.BundleUtils;
import org.terasology.launcher.util.HostServices;

public class FooterController {
    private static final Logger logger = LoggerFactory.getLogger(FooterController.class);
    @FXML
    private Button warningButton;
    @FXML
    private Label versionInfo;
    private HostServices hostServices;
    private Property<Optional<Warning>> warningProperty = new SimpleObjectProperty(Optional.empty());

    private void updateLabels() {
        String launcherVersion = LauncherVersion.getInstance().getDisplayName();
        if (launcherVersion.isEmpty()) {
            this.versionInfo.setText(BundleUtils.getLabel("launcher_versionInfo"));
        } else {
            this.versionInfo.setText(launcherVersion);
        }
    }

    public void setHostServices(HostServices hostServices) {
        this.hostServices = hostServices;
    }

    @FXML
    public void initialize() {
        this.updateLabels();
        this.warningProperty.addListener((value, oldValue, newValue) -> this.updateWarningButton((Optional<Warning>)newValue));
    }

    @FXML
    protected void handleSocialButtonMouseEntered(MouseEvent event) {
        Node source = (Node)event.getSource();
        ScaleTransition t = Effects.createScaleTransition(1.2, source);
        t.playFromStart();
    }

    @FXML
    protected void handleSocialButtonMouseExited(MouseEvent event) {
        Node source = (Node)event.getSource();
        ScaleTransition t = Effects.createScaleTransition(1.0, source);
        t.playFromStart();
    }

    @FXML
    protected void handleSocialButtonMousePressed(MouseEvent event) {
        Node source = (Node)event.getSource();
        ScaleTransition t = Effects.createScaleTransition(0.8, source);
        t.playFromStart();
    }

    @FXML
    protected void handleSocialButtonMouseReleased(MouseEvent event) {
        Node source = (Node)event.getSource();
        ScaleTransition t = Effects.createScaleTransition(1.2, source);
        t.playFromStart();
    }

    @FXML
    protected void openFacebook() {
        this.hostServices.tryOpenUri(BundleUtils.getURI("terasology_facebook"));
    }

    @FXML
    protected void openGithub() {
        this.hostServices.tryOpenUri(BundleUtils.getURI("terasology_github"));
    }

    @FXML
    protected void openDiscord() {
        this.hostServices.tryOpenUri(BundleUtils.getURI("terasology_discord"));
    }

    @FXML
    protected void openReddit() {
        this.hostServices.tryOpenUri(BundleUtils.getURI("terasology_reddit"));
    }

    @FXML
    protected void openTwitter() {
        this.hostServices.tryOpenUri(BundleUtils.getURI("terasology_twitter"));
    }

    @FXML
    protected void openYoutube() {
        this.hostServices.tryOpenUri(BundleUtils.getURI("terasology_youtube"));
    }

    @FXML
    protected void openLogs() {
    }

    private void updateWarningButton(Optional<Warning> warning) {
        this.warningButton.setVisible(warning.isPresent());
        warning.ifPresent(w -> {
            String msg = BundleUtils.getLabel(w.getMessageKey());
            this.warningButton.setTooltip(new Tooltip(msg));
            logger.warn(msg);
        });
    }

    void bind(ReadOnlyProperty<Optional<Warning>> property) {
        this.warningProperty.bind(property);
    }
}

