/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.terasology.launcher.model.Build;
import org.terasology.launcher.model.GameIdentifier;
import org.terasology.launcher.model.GameRelease;
import org.terasology.launcher.util.BundleUtils;

final class GameReleaseCell
extends ListCell<GameRelease> {
    private static final Image ICON_CHECK = BundleUtils.getFxImage("icon_check");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private final ImageView iconStatus;
    private final Set<GameIdentifier> installedGames;
    private final boolean isButtonCell;

    GameReleaseCell(Set<GameIdentifier> installedGames) {
        this(installedGames, false);
    }

    GameReleaseCell(Set<GameIdentifier> installedGames, boolean isButtonCell) {
        this.installedGames = installedGames;
        this.isButtonCell = isButtonCell;
        this.iconStatus = new ImageView(ICON_CHECK);
    }

    protected void updateItem(GameRelease item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String displayVersion;
            GameIdentifier id = item.getId();
            if (id.getBuild().equals((Object)Build.NIGHTLY)) {
                this.setStyle("-fx-font-weight: normal");
                displayVersion = "preview " + id.getDisplayVersion() + " (" + DATE_FORMAT.format(item.getTimestamp()) + ")";
            } else {
                this.setStyle("-fx-font-weight: bold");
                displayVersion = "release " + id.getDisplayVersion();
            }
            this.setText(displayVersion);
            this.iconStatus.setVisible(this.installedGames.contains(id));
            if (!this.isButtonCell) {
                this.setGraphic((Node)this.iconStatus);
            }
        }
    }
}

