/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class LogViewController
extends AppenderBase<ILoggingEvent> {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private final StringBuffer buffer = new StringBuffer();
    private final ThrowableHandlingConverter throwableConverter = new RootCauseFirstThrowableProxyConverter();
    @FXML
    private TextArea logArea;

    public LogViewController() {
        ScheduledService<Void> schedule = new ScheduledService<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        LogViewController.this.logArea.appendText(LogViewController.this.buffer.toString());
                        LogViewController.this.buffer.delete(0, LogViewController.this.buffer.length());
                        return null;
                    }
                };
            }
        };
        schedule.setPeriod(Duration.seconds((double)2.0));
        schedule.start();
    }

    @FXML
    public void initialize() {
        this.logArea.setEditable(false);
        this.logArea.setFont(Font.font((String)"monospaced"));
    }

    private LocalDateTime timestampFromEvent(ILoggingEvent loggingEvent) {
        return new Date(loggingEvent.getTimeStamp()).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    protected void append(ILoggingEvent loggingEvent) {
        String message = loggingEvent.getFormattedMessage();
        LocalDateTime timestamp = this.timestampFromEvent(loggingEvent);
        this.buffer.append(String.format("%s | %-5s | ", DATE_FORMATTER.format(timestamp), loggingEvent.getLevel()));
        this.buffer.append(message);
        this.buffer.append("\n");
        IThrowableProxy error = loggingEvent.getThrowableProxy();
        if (error != null) {
            String s = this.throwableConverter.convert(loggingEvent);
            this.buffer.append(s);
        }
    }
}

