/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.tasks.ProgressListener;
import org.terasology.launcher.util.DownloadException;

public final class DownloadUtils {
    private static final Logger logger = LoggerFactory.getLogger(DownloadUtils.class);
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    private static final Duration READ_TIMEOUT = Duration.ofMinutes(5L);

    private DownloadUtils() {
    }

    public static CompletableFuture<Void> downloadToFile(URL downloadURL, Path file, ProgressListener listener) throws DownloadException {
        listener.update(0);
        CompletableFuture<HttpResponse<InputStream>> result = DownloadUtils.getConnectedDownloadConnection(downloadURL);
        return result.thenAcceptAsync(response -> {
            long contentLength = response.headers().firstValueAsLong("content-length").orElse(0L);
            logger.debug("Download file '{}' ({}; {}) from URL '{}'.", file, contentLength, response.headers().firstValue("content-type"), downloadURL);
            try (BufferedInputStream in = new BufferedInputStream((InputStream)response.body());
                 BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
                DownloadUtils.downloadToFile(listener, contentLength, in, out);
            }
            catch (IOException e) {
                throw new DownloadException("Could not download file from URL! URL=" + downloadURL + ", file=" + file, e);
            }
            if (!listener.isCancelled()) {
                try {
                    if (Files.size(file) != contentLength) {
                        throw new DownloadException("Wrong file length after download! " + Files.size(file) + " != " + contentLength);
                    }
                }
                catch (IOException e) {
                    throw new DownloadException("Failed to read the file length after download!", e);
                }
                listener.update(100);
            }
        });
    }

    public static long getContentLength(URL downloadURL) throws DownloadException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)downloadURL.openConnection();
            connection.setRequestMethod("HEAD");
            long l = connection.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            throw new DownloadException("Could not send HEAD request to HTTP-URL! URL=" + downloadURL, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static CompletableFuture<HttpResponse<InputStream>> getConnectedDownloadConnection(URL downloadURL) throws DownloadException {
        HttpRequest request;
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(CONNECT_TIMEOUT).build();
        try {
            request = HttpRequest.newBuilder(downloadURL.toURI()).timeout(READ_TIMEOUT).build();
        }
        catch (URISyntaxException e) {
            throw new DownloadException("Error in URL: " + downloadURL, e);
        }
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream());
    }

    private static void downloadToFile(ProgressListener listener, long contentLength, BufferedInputStream in, BufferedOutputStream out) throws IOException {
        byte[] buffer = new byte[2048];
        float sizeFactor = 100.0f / (float)contentLength;
        long writtenBytes = 0L;
        if (!listener.isCancelled()) {
            int n;
            while ((n = in.read(buffer)) != -1 && !listener.isCancelled()) {
                out.write(buffer, 0, n);
                int percentage = (int)(sizeFactor * (float)(writtenBytes += (long)n));
                if (percentage < 1) {
                    percentage = 1;
                } else if (percentage >= 100) {
                    percentage = 99;
                }
                listener.update(percentage);
                if (!listener.isCancelled()) continue;
                break;
            }
        }
    }
}

