/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostServices {
    private static final Logger logger = LoggerFactory.getLogger(HostServices.class);
    private final Desktop desktop;

    public HostServices() {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            this.desktop = Desktop.getDesktop();
        } else {
            logger.info("java.awt.Desktop is not supported or does not support BROWSE action - cannot open links in browser");
            this.desktop = null;
        }
    }

    public void tryOpenUri(URI uri) {
        if (this.desktop != null) {
            EventQueue.invokeLater(() -> {
                try {
                    this.desktop.browse(uri);
                }
                catch (IOException e) {
                    logger.warn("Unable to open URI '{}': {}", (Object)uri.toString(), (Object)e.getMessage());
                }
            });
        }
    }
}

