/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.util.FileUtils;
import org.terasology.launcher.util.GameDataDirectoryNames;
import org.terasology.launcher.util.Platform;

public final class LauncherDirectoryUtils {
    public static final String LAUNCHER_APPLICATION_DIR_NAME = "TerasologyLauncher";
    public static final String GAME_APPLICATION_DIR_NAME = "Terasology";
    public static final String GAME_DATA_DIR_NAME = "Terasology";
    public static final String CACHE_DIR_NAME = "cache";
    private static final String PROPERTY_USER_HOME = "user.home";
    private static final String ENV_APPDATA = "APPDATA";
    private static final String MAC_PATH = "Library/Application Support/";
    private static final Logger logger = LoggerFactory.getLogger(LauncherDirectoryUtils.class);

    private LauncherDirectoryUtils() {
    }

    public static boolean containsGameData(Path gameInstallationPath) {
        boolean containsGameData = false;
        if (FileUtils.isReadableDir(gameInstallationPath)) {
            try (Stream<Path> stream = Files.list(gameInstallationPath);){
                containsGameData = stream.anyMatch(child -> Files.isDirectory(child, new LinkOption[0]) && LauncherDirectoryUtils.isGameDataDirectoryName(child.getFileName().toString()) && LauncherDirectoryUtils.containsFiles(child));
            }
            catch (IOException e) {
                logger.error("Failed to check if folder contains game data", e);
            }
        }
        return containsGameData;
    }

    private static boolean isGameDataDirectoryName(String directoryName) {
        return Arrays.stream(GameDataDirectoryNames.values()).anyMatch(gameDataDirectoryNames -> gameDataDirectoryNames.getName().equals(directoryName));
    }

    public static boolean containsFiles(Path directory) {
        boolean bl;
        block9: {
            if (directory == null || !Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
                return false;
            }
            Stream<Path> stream = Files.list(directory);
            try {
                bl = stream.anyMatch(file -> Files.isRegularFile(file, new LinkOption[0]) || Files.isDirectory(file, new LinkOption[0]) && LauncherDirectoryUtils.containsFiles(file));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public static Path getApplicationDirectory(Platform platform, String applicationName) {
        String envAppData;
        Path userHome = Paths.get(System.getProperty(PROPERTY_USER_HOME, "."), new String[0]);
        Path applicationDirectory = platform.isWindows() ? ((envAppData = System.getenv(ENV_APPDATA)) != null && envAppData.length() > 0 ? Paths.get(envAppData, new String[0]).resolve(applicationName) : userHome.resolve(applicationName)) : (platform.isLinux() ? userHome.resolve("." + applicationName.toLowerCase(Locale.ENGLISH)) : (platform.isMac() ? userHome.resolve(MAC_PATH + applicationName) : userHome.resolve(applicationName)));
        return applicationDirectory;
    }

    public static Path getGameDataDirectory(Platform platform) {
        Path gameDataDirectory;
        Path userHome = Paths.get(System.getProperty(PROPERTY_USER_HOME, "."), new String[0]);
        if (platform.isWindows()) {
            Path path = Paths.get(System.getenv(ENV_APPDATA), new String[0]);
            gameDataDirectory = path.resolve("Terasology");
        } else {
            gameDataDirectory = platform.isLinux() ? userHome.resolve("." + "Terasology".toLowerCase(Locale.ENGLISH)) : (platform.isMac() ? userHome.resolve("Library/Application Support/Terasology") : userHome.resolve("Terasology"));
        }
        return gameDataDirectory;
    }

    public static Path getInstallationDirectory() {
        URL location = LauncherDirectoryUtils.class.getProtectionDomain().getCodeSource().getLocation();
        Path installationDirectory = null;
        try {
            Path launcherLocation = Paths.get(location.toURI());
            logger.trace("Launcher location: {}", (Object)launcherLocation);
            installationDirectory = launcherLocation.getParent().getParent();
            logger.trace("Launcher installation directory: {}", (Object)installationDirectory);
        }
        catch (URISyntaxException e) {
            logger.error("Could not determine launcher installation directory.", e);
        }
        return installationDirectory;
    }
}

