/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number;

import com.ibm.icu.impl.number.Modifier;
import com.ibm.icu.impl.number.NumberStringBuilder;
import java.util.ArrayDeque;

public class ModifierHolder {
    private ArrayDeque<Modifier> mods = new ArrayDeque();

    public ModifierHolder clear() {
        this.mods.clear();
        return this;
    }

    public void add(Modifier modifier) {
        if (modifier != null) {
            this.mods.addFirst(modifier);
        }
    }

    public Modifier peekLast() {
        return this.mods.peekLast();
    }

    public Modifier removeLast() {
        return this.mods.removeLast();
    }

    public int applyAll(NumberStringBuilder string, int leftIndex, int rightIndex) {
        int addedLength = 0;
        while (!this.mods.isEmpty()) {
            Modifier mod = this.mods.removeFirst();
            addedLength += mod.apply(string, leftIndex, rightIndex + addedLength);
        }
        return addedLength;
    }

    public int applyStrong(NumberStringBuilder string, int leftIndex, int rightIndex) {
        int addedLength = 0;
        while (!this.mods.isEmpty() && this.mods.peekFirst().isStrong()) {
            Modifier mod = this.mods.removeFirst();
            addedLength += mod.apply(string, leftIndex, rightIndex + addedLength);
        }
        return addedLength;
    }

    public int totalLength() {
        int length = 0;
        for (Modifier mod : this.mods) {
            if (mod == null) continue;
            length += mod.length();
        }
        return length;
    }
}

