/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.settings;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.settings.LauncherSettings;
import org.terasology.launcher.settings.SettingsValidationRule;
import org.terasology.launcher.util.JavaHeapSize;

public final class LauncherSettingsValidator {
    private static final Logger logger = LoggerFactory.getLogger(LauncherSettingsValidator.class);
    private static final Set<String> DEPRECATED_PARAMETERS = Sets.newHashSet((Object[])new String[]{"-XX:+UseParNewGC", "-XX:+UseConcMarkSweepGC", "-XX:ParallelGCThreads=10"});
    private static final List<SettingsValidationRule> RULES = Arrays.asList(new SettingsValidationRule(s -> !System.getProperty("os.arch").equals("x86") || s.getMaxHeapSize().compareTo(JavaHeapSize.GB_1_5) <= 0, "Max heap size cannot be greater than 1.5 GB for a 32-bit JVM", s -> s.setMaxHeapSize(JavaHeapSize.GB_1_5)), new SettingsValidationRule(s -> s.getInitialHeapSize().compareTo(s.getMaxHeapSize()) < 0, "Initial heap size cannot be greater than max heap size", s -> s.setInitialHeapSize(s.getMaxHeapSize())), new SettingsValidationRule(s -> s.getUserGameParameterList().stream().anyMatch(DEPRECATED_PARAMETERS::contains), "Ensure unsupported JVM arguments are removed", s -> s.setUserJavaParameters(LauncherSettingsValidator.removeUnsupportedJvmParameters(s.getJavaParameterList()))));

    private LauncherSettingsValidator() {
    }

    private static String removeUnsupportedJvmParameters(List<String> params) {
        ArrayList correctedParams = Lists.newArrayList(params);
        correctedParams.removeAll(DEPRECATED_PARAMETERS);
        return String.join((CharSequence)" ", correctedParams);
    }

    public static void validate(LauncherSettings settings) {
        for (SettingsValidationRule rule : RULES) {
            if (!rule.isBrokenBy(settings)) continue;
            logger.warn(rule.getInvalidationMessage());
            rule.correct(settings);
        }
    }
}

