/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.settings;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.terasology.launcher.settings.LauncherSettings;

public class SettingsValidationRule {
    private final Predicate<LauncherSettings> condition;
    private final String invalidationMessage;
    private final Consumer<LauncherSettings> correction;

    public SettingsValidationRule(Predicate<LauncherSettings> condition, String invalidationMessage, Consumer<LauncherSettings> correction) {
        this.condition = condition;
        this.invalidationMessage = invalidationMessage;
        this.correction = correction;
    }

    public boolean isBrokenBy(LauncherSettings settings) {
        return !this.condition.test(settings);
    }

    public String getInvalidationMessage() {
        return this.invalidationMessage;
    }

    public void correct(LauncherSettings settings) {
        this.correction.accept(settings);
    }
}

