/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import com.google.common.io.Files;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.util.BundleUtils;

public class AboutViewController {
    private static final Logger logger = LoggerFactory.getLogger(AboutViewController.class);
    private static final String ABOUT = "about";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @FXML
    private Accordion aboutInfoAccordion;
    private final Parser parser;
    private final HtmlRenderer renderer;

    public AboutViewController() {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(EmojiExtension.create()));
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    @FXML
    public void initialize() {
        this.update();
    }

    public void update() {
        this.aboutInfoAccordion.getPanes().clear();
        Stream.of("README.md", "CHANGELOG.md", "CONTRIBUTING.md", "LICENSE").map(filename -> BundleUtils.getFXMLUrl(ABOUT, filename)).filter(Objects::nonNull).map(this::createPaneFor).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> this.aboutInfoAccordion.getPanes().add(arg_0));
        if (!this.aboutInfoAccordion.getPanes().isEmpty()) {
            this.aboutInfoAccordion.setExpandedPane((TitledPane)this.aboutInfoAccordion.getPanes().get(0));
        }
    }

    private Optional<TitledPane> createPaneFor(URL url) {
        return this.createViewFor(url).map(view -> {
            view.getStylesheets().add((Object)BundleUtils.getFXMLUrl("css_webview").toExternalForm());
            view.setContextMenuEnabled(false);
            return view;
        }).map(view -> {
            AnchorPane pane = new AnchorPane();
            AnchorPane.setBottomAnchor((Node)view, (Double)0.0);
            AnchorPane.setTopAnchor((Node)view, (Double)0.0);
            pane.getChildren().add(view);
            return pane;
        }).map(contentPane -> {
            String fname = Files.getNameWithoutExtension((String)url.getFile());
            TitledPane titledPane = new TitledPane(fname, (Node)contentPane);
            titledPane.setAnimated(false);
            return titledPane;
        });
    }

    private Optional<WebView> createViewFor(URL url) {
        switch (Files.getFileExtension((String)url.getFile().toLowerCase())) {
            case "md": 
            case "markdown": {
                return this.renderMarkdown(url);
            }
            case "htm": 
            case "html": {
                return this.renderHtml(url);
            }
        }
        return this.renderUnknown(url);
    }

    private Optional<WebView> renderMarkdown(URL url) {
        WebView view = null;
        try (InputStream input = url.openStream();){
            view = new WebView();
            Document document = this.parser.parseReader((Reader)new InputStreamReader(input));
            String content = "<body style='padding-left:24px;'>\n" + this.renderer.render((com.vladsch.flexmark.util.ast.Node)document) + "</body>";
            view.getEngine().loadContent(content, "text/html");
        }
        catch (IOException e) {
            logger.warn("Could not render markdown file: {}", (Object)url);
        }
        return Optional.ofNullable(view);
    }

    private Optional<WebView> renderHtml(URL url) {
        WebView view = new WebView();
        view.getEngine().load(url.toExternalForm());
        return Optional.of(view);
    }

    private Optional<WebView> renderUnknown(URL url) {
        WebView view = null;
        try (InputStreamReader isr = new InputStreamReader(url.openStream(), UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            view = new WebView();
            StringBuilder content = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                content.append(line);
                content.append(System.lineSeparator());
                line = br.readLine();
            }
            view.getEngine().loadContent(content.toString(), "text/plain");
        }
        catch (IOException e) {
            logger.warn("Could not render file: {}", (Object)url);
        }
        return Optional.ofNullable(view);
    }
}

