/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.util.Duration;

public final class FxTimer {
    private final Duration actionTime;
    private final Timeline timeline;
    private final Runnable action;
    private long seq;

    private FxTimer(java.time.Duration actionTime, java.time.Duration period, Runnable action, int cycles) {
        this.actionTime = Duration.millis((double)actionTime.toMillis());
        this.timeline = new Timeline();
        this.action = action;
        this.timeline.getKeyFrames().add((Object)new KeyFrame(this.actionTime, new KeyValue[0]));
        if (period != actionTime) {
            this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)period.toMillis()), new KeyValue[0]));
        }
        this.timeline.setCycleCount(cycles);
    }

    public static FxTimer create(java.time.Duration delay, Runnable action) {
        return new FxTimer(delay, delay, action, 1);
    }

    public static FxTimer runLater(java.time.Duration delay, Runnable action) {
        FxTimer timer = FxTimer.create(delay, action);
        timer.restart();
        return timer;
    }

    public void restart() {
        this.stop();
        long expected = this.seq;
        this.timeline.getKeyFrames().set(0, (Object)new KeyFrame(this.actionTime, ae -> {
            if (this.seq == expected) {
                this.action.run();
            }
        }, new KeyValue[0]));
        this.timeline.play();
    }

    public void stop() {
        this.timeline.stop();
        ++this.seq;
    }
}

