/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import java.io.IOException;
import java.nio.file.Path;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.terasology.launcher.settings.LauncherSettings;
import org.terasology.launcher.settings.Settings;
import org.terasology.launcher.ui.ApplicationController;
import org.terasology.launcher.ui.Dialogs;
import org.terasology.launcher.util.BundleUtils;
import org.terasology.launcher.util.JavaHeapSize;
import org.terasology.launcher.util.Languages;

public class SettingsController {
    private static final Logger logger = LoggerFactory.getLogger(SettingsController.class);
    private Path launcherDirectory;
    private LauncherSettings launcherSettings;
    private ApplicationController appController;
    private Path gameDirectory;
    private Path gameDataDirectory;
    private Stage stage;
    @FXML
    private Label gameSettingsTitle;
    @FXML
    private Label maxHeapSizeLabel;
    @FXML
    private Label initialHeapSizeLabel;
    @FXML
    private Button gameDirectoryOpenButton;
    @FXML
    private Button gameDataDirectoryOpenButton;
    @FXML
    private Label gameDirectoryLabel;
    @FXML
    private Label gameDataDirectoryLabel;
    @FXML
    private Label javaParametersLabel;
    @FXML
    private Label gameParametersLabel;
    @FXML
    private Label logLevelLabel;
    @FXML
    private Label launcherSettingsTitle;
    @FXML
    private Label chooseLanguageLabel;
    @FXML
    private CheckBox closeAfterStartBox;
    @FXML
    private CheckBox showPreReleasesBox;
    @FXML
    private CheckBox saveDownloadedFilesBox;
    @FXML
    private Label launcherDirectoryLabel;
    @FXML
    private Button launcherDirectoryOpenButton;
    @FXML
    private Button saveSettingsButton;
    @FXML
    private Button cancelSettingsButton;
    @FXML
    private ComboBox<JavaHeapSize> maxHeapSizeBox;
    @FXML
    private ComboBox<JavaHeapSize> initialHeapSizeBox;
    @FXML
    private ComboBox<String> languageBox;
    @FXML
    private TextField gameDirectoryPath;
    @FXML
    private TextField gameDataDirectoryPath;
    @FXML
    private TextField launcherDirectoryPath;
    @FXML
    private TextField userJavaParametersField;
    @FXML
    private TextField userGameParametersField;
    @FXML
    private ComboBox<Level> logLevelBox;

    @FXML
    protected void cancelSettingsAction(ActionEvent event) {
        ((Node)event.getSource()).getScene().getWindow().hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    protected void saveSettingsAction(ActionEvent event) {
        this.launcherSettings.setGameDirectory(this.gameDirectory);
        this.launcherSettings.setGameDataDirectory(this.gameDataDirectory);
        this.launcherSettings.setMaxHeapSize((JavaHeapSize)((Object)this.maxHeapSizeBox.getSelectionModel().getSelectedItem()));
        this.launcherSettings.setInitialHeapSize((JavaHeapSize)((Object)this.initialHeapSizeBox.getSelectionModel().getSelectedItem()));
        this.launcherSettings.setLogLevel((Level)((Object)this.logLevelBox.getSelectionModel().getSelectedItem()));
        Languages.update(Languages.SUPPORTED_LOCALES.get(this.languageBox.getSelectionModel().getSelectedIndex()));
        this.launcherSettings.setLocale(Languages.getCurrentLocale());
        this.launcherSettings.setCloseLauncherAfterGameStart(this.closeAfterStartBox.isSelected());
        this.launcherSettings.setShowPreReleases(this.showPreReleasesBox.isSelected());
        this.launcherSettings.setKeepDownloadedFiles(this.saveDownloadedFilesBox.isSelected());
        if (this.userJavaParametersField.getText().isEmpty()) {
            this.launcherSettings.setUserJavaParameters("-XX:MaxGCPauseMillis=20");
        } else {
            logger.debug("User defined Java parameters: {}", (Object)this.userJavaParametersField.getText());
            this.launcherSettings.setUserJavaParameters(this.userJavaParametersField.getText());
        }
        if (this.userGameParametersField.getText().isEmpty()) {
            this.launcherSettings.setUserGameParameters("");
        } else {
            logger.debug("User defined game parameters: {}", (Object)this.userGameParametersField.getText());
            this.launcherSettings.setUserGameParameters(this.userGameParametersField.getText());
        }
        Path settingsFile = this.launcherDirectory.resolve("TerasologyLauncherSettings.properties");
        try {
            Settings.store(this.launcherSettings, settingsFile);
        }
        catch (IOException e) {
            logger.error("The launcher settings cannot be stored! '{}'", (Object)settingsFile, (Object)e);
            Dialogs.showError(this.stage, BundleUtils.getLabel("message_error_storeSettings"));
        }
        finally {
            ((Node)event.getSource()).getScene().getWindow().hide();
        }
    }

    @FXML
    protected void openGameDirectoryAction() {
        Dialogs.openFileBrowser(this.stage, this.gameDirectory, BundleUtils.getLabel("message_error_gameDirectory"));
    }

    @FXML
    protected void openGameDataDirectoryAction() {
        Dialogs.openFileBrowser(this.stage, this.gameDataDirectory, BundleUtils.getLabel("message_error_gameDataDirectory"));
    }

    @FXML
    protected void openLauncherDirectoryAction() {
        Dialogs.openFileBrowser(this.stage, this.launcherDirectory, BundleUtils.getLabel("message_error_launcherDirectory"));
    }

    @FXML
    protected void updateMaxHeapSizeBox() {
        JavaHeapSize initialHeapSize = (JavaHeapSize)((Object)this.initialHeapSizeBox.getSelectionModel().getSelectedItem());
        JavaHeapSize maxHeapSize = (JavaHeapSize)((Object)this.maxHeapSizeBox.getSelectionModel().getSelectedItem());
        if (initialHeapSize != null && maxHeapSize != null && maxHeapSize.compareTo(initialHeapSize) < 0) {
            this.initialHeapSizeBox.getSelectionModel().select((Object)maxHeapSize);
        }
    }

    @FXML
    protected void updateInitialHeapSizeBox() {
        JavaHeapSize initialHeapSize = (JavaHeapSize)((Object)this.initialHeapSizeBox.getSelectionModel().getSelectedItem());
        JavaHeapSize maxHeapSize = (JavaHeapSize)((Object)this.maxHeapSizeBox.getSelectionModel().getSelectedItem());
        if (initialHeapSize != null && maxHeapSize != null && maxHeapSize.compareTo(initialHeapSize) < 0) {
            this.maxHeapSizeBox.getSelectionModel().select((Object)initialHeapSize);
        }
    }

    void initialize(Path newLauncherDirectory, LauncherSettings newLauncherSettings, Stage newStage, ApplicationController newAppController) {
        this.launcherDirectory = newLauncherDirectory;
        this.launcherSettings = newLauncherSettings;
        this.stage = newStage;
        this.appController = newAppController;
        this.populateHeapSize();
        this.populateLanguageValues();
        this.populateLanguageIcons();
        this.populateCloseLauncherAfterGameStart();
        this.populateSaveDownloadedFiles();
        this.populateShowPreReleases();
        this.populateLogLevel();
        this.gameDirectory = newLauncherSettings.getGameDirectory();
        this.gameDataDirectory = newLauncherSettings.getGameDataDirectory();
        this.updateDirectoryPathLabels();
        this.initUserParameterFields();
        this.setLabelStrings();
    }

    private void setLabelStrings() {
        this.gameSettingsTitle.setText(BundleUtils.getLabel("settings_game_title"));
        this.maxHeapSizeLabel.setText(BundleUtils.getLabel("settings_game_maxHeapSize"));
        this.initialHeapSizeLabel.setText(BundleUtils.getLabel("settings_game_initialHeapSize"));
        this.gameDirectoryOpenButton.setText(BundleUtils.getLabel("settings_game_gameDirectory_open"));
        this.gameDataDirectoryOpenButton.setText(BundleUtils.getLabel("settings_game_gameDataDirectory_open"));
        this.gameDirectoryLabel.setText(BundleUtils.getLabel("settings_game_gameDirectory"));
        this.gameDataDirectoryLabel.setText(BundleUtils.getLabel("settings_game_gameDataDirectory"));
        this.userJavaParametersField.setPromptText(BundleUtils.getLabel("settings_game_javaParsPrompt"));
        this.userGameParametersField.setPromptText(BundleUtils.getLabel("settings_game_gameParsPrompt"));
        this.javaParametersLabel.setText(BundleUtils.getLabel("settings_game_javaParameters"));
        this.gameParametersLabel.setText(BundleUtils.getLabel("settings_game_gameParameters"));
        this.logLevelLabel.setText(BundleUtils.getLabel("settings_game_logLevel"));
        this.launcherSettingsTitle.setText(BundleUtils.getLabel("settings_launcher_title"));
        this.chooseLanguageLabel.setText(BundleUtils.getLabel("settings_launcher_chooseLanguage"));
        this.closeAfterStartBox.setText(BundleUtils.getLabel("settings_launcher_closeLauncherAfterGameStart"));
        this.saveDownloadedFilesBox.setText(BundleUtils.getLabel("settings_launcher_saveDownloadedFiles"));
        this.showPreReleasesBox.setText(BundleUtils.getLabel("settings_launcher_showPreReleases"));
        this.launcherDirectoryLabel.setText(BundleUtils.getLabel("settings_launcher_launcherDirectory"));
        this.launcherDirectoryOpenButton.setText(BundleUtils.getLabel("settings_launcher_launcherDirectory_open"));
        this.saveSettingsButton.setText(BundleUtils.getLabel("settings_save"));
        this.cancelSettingsButton.setText(BundleUtils.getLabel("settings_cancel"));
    }

    private void populateHeapSize() {
        JavaHeapSize[] heapSizeRange;
        this.maxHeapSizeBox.getItems().clear();
        this.initialHeapSizeBox.getItems().clear();
        for (JavaHeapSize heapSize : heapSizeRange = System.getProperty("os.arch").equals("x86") ? Arrays.copyOfRange(JavaHeapSize.values(), 0, JavaHeapSize.GB_1_5.ordinal() + 1) : JavaHeapSize.values()) {
            this.maxHeapSizeBox.getItems().add((Object)heapSize);
            this.initialHeapSizeBox.getItems().add((Object)heapSize);
        }
        this.updateHeapSizeSelection();
    }

    private void populateLanguageValues() {
        this.languageBox.getItems().clear();
        for (Locale locale : Languages.SUPPORTED_LOCALES) {
            String item = locale.toLanguageTag() + " : " + BundleUtils.getLabel(locale, Languages.SETTINGS_LABEL_KEYS.get(locale));
            if (!locale.equals(Languages.getCurrentLocale())) {
                item = item + " (" + BundleUtils.getLabel(Languages.SETTINGS_LABEL_KEYS.get(locale)) + ")";
            }
            this.languageBox.getItems().add((Object)item);
            if (!Languages.getCurrentLocale().equals(locale)) continue;
            this.languageBox.getSelectionModel().select((Object)item);
        }
        Collator coll = Collator.getInstance();
        this.languageBox.getItems().sort((Comparator)coll);
    }

    private void populateLanguageIcons() {
        this.languageBox.setCellFactory(p -> new LanguageIconListCell());
        this.languageBox.setButtonCell((ListCell)this.languageBox.getCellFactory().call(null));
    }

    private void populateCloseLauncherAfterGameStart() {
        this.closeAfterStartBox.setSelected(this.launcherSettings.isCloseLauncherAfterGameStart());
    }

    private void populateShowPreReleases() {
        this.showPreReleasesBox.setSelected(this.launcherSettings.isShowPreReleases());
    }

    private void populateSaveDownloadedFiles() {
        this.saveDownloadedFilesBox.setSelected(this.launcherSettings.isKeepDownloadedFiles());
    }

    private void populateLogLevel() {
        this.logLevelBox.getItems().clear();
        for (Level level : Level.values()) {
            this.logLevelBox.getItems().add((Object)level);
        }
        this.updateLogLevelSelection();
    }

    private void updateDirectoryPathLabels() {
        this.gameDirectoryPath.setText(this.gameDirectory.toString());
        this.gameDataDirectoryPath.setText(this.gameDataDirectory.toString());
        this.launcherDirectoryPath.setText(this.launcherDirectory.toString());
    }

    private void updateHeapSizeSelection() {
        this.maxHeapSizeBox.getSelectionModel().select((Object)this.launcherSettings.getMaxHeapSize());
        this.initialHeapSizeBox.getSelectionModel().select((Object)this.launcherSettings.getInitialHeapSize());
    }

    private void updateLogLevelSelection() {
        this.logLevelBox.getSelectionModel().select((Object)this.launcherSettings.getLogLevel());
    }

    private void initUserParameterFields() {
        if (!this.launcherSettings.getUserJavaParameters().equals("-XX:MaxGCPauseMillis=20")) {
            this.userJavaParametersField.setText(this.launcherSettings.getUserJavaParameters());
        }
        if (!this.launcherSettings.getUserGameParameters().equals("")) {
            this.userGameParametersField.setText(this.launcherSettings.getUserGameParameters());
        }
    }

    private static class LanguageIconListCell
    extends ListCell<String> {
        private LanguageIconListCell() {
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(item);
            if (item == null || empty) {
                this.setGraphic(null);
            } else {
                String countryCode = this.getText().split(":")[0].trim();
                String id = "flag_" + countryCode;
                try {
                    Image icon = BundleUtils.getFxImage(id);
                    ImageView iconImageView = new ImageView(icon);
                    iconImageView.setFitHeight(11.0);
                    iconImageView.setPreserveRatio(true);
                    this.setGraphic((Node)iconImageView);
                }
                catch (MissingResourceException e) {
                    logger.warn("ImageBundle key {} not found", (Object)id);
                }
                catch (NullPointerException e) {
                    logger.warn("Flag icon in ImageBundle key {} missing or corrupt", (Object)id);
                }
            }
        }
    }
}

