/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util.visitor;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class LocalCopyVisitor
extends SimpleFileVisitor<Path> {
    private final Path sourceDirectory;
    private final Path targetDirectory;

    public LocalCopyVisitor(Path sourceDirectory, Path targetDirectory) {
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.copy(file, this.targetDirectory.resolve(this.sourceDirectory.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path dirToCreate = this.targetDirectory.resolve(this.sourceDirectory.relativize(dir));
        if (Files.notExists(dirToCreate, new LinkOption[0])) {
            Files.createDirectories(dirToCreate, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }
}

