/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QuotesPropertyBuilder
extends AbstractPropertyBuilder {
    @Override
    public List buildDeclarations(CSSName cssName, List values, int origin, boolean important, boolean inheritAllowed) {
        if (values.size() == 1) {
            IdentValue ident;
            PropertyValue value = (PropertyValue)values.get(0);
            if (value.getCssValueType() == 0) {
                return Collections.EMPTY_LIST;
            }
            if (value.getPrimitiveType() == 21 && (ident = this.checkIdent(CSSName.QUOTES, value)) == IdentValue.NONE) {
                return Collections.singletonList(new PropertyDeclaration(CSSName.QUOTES, value, important, origin));
            }
        }
        if (values.size() % 2 == 1) {
            throw new CSSParseException("Mismatched quotes " + values, -1);
        }
        ArrayList<PropertyValue> resultValues = new ArrayList<PropertyValue>();
        for (PropertyValue value : values) {
            if (value.getOperator() != null) {
                throw new CSSParseException("Found unexpected operator, " + value.getOperator().getExternalName(), -1);
            }
            short type = value.getPrimitiveType();
            if (type == 19) {
                resultValues.add(value);
                continue;
            }
            if (type == 20) {
                throw new CSSParseException("URI is not allowed here", -1);
            }
            if (value.getPropertyValueType() == 7) {
                throw new CSSParseException("Function " + value.getFunction().getName() + " is not allowed here", -1);
            }
            if (type == 21) {
                throw new CSSParseException("Identifier is not a valid value for the quotes property", -1);
            }
            throw new CSSParseException(value.getCssText() + " is not a value value for the quotes property", -1);
        }
        if (resultValues.size() > 0) {
            return Collections.singletonList(new PropertyDeclaration(CSSName.QUOTES, new PropertyValue(resultValues), important, origin));
        }
        return Collections.EMPTY_LIST;
    }
}

