/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHCommitComment
extends GHObject
implements Reactable {
    private GHRepository owner;
    String body;
    String html_url;
    String commit_id;
    Integer line;
    String path;
    GHUser user;

    public GHRepository getOwner() {
        return this.owner;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public String getSHA1() {
        return this.commit_id;
    }

    public String getBody() {
        return this.body;
    }

    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line != null ? this.line : -1;
    }

    public GHUser getUser() throws IOException {
        return this.owner == null || this.owner.root.isOffline() ? this.user : this.owner.root.getUser(this.user.login);
    }

    public GHCommit getCommit() throws IOException {
        return this.getOwner().getCommit(this.getSHA1());
    }

    public void update(String body) throws IOException {
        ((Requester)((Requester)((Requester)this.owner.root.createRequest().method("PATCH")).with("body", body)).withUrlPath(this.getApiTail(), new String[0])).fetch(GHCommitComment.class);
        this.body = body;
    }

    @Override
    @Preview(value={Previews.SQUIRREL_GIRL})
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.owner.root.createRequest().method("POST")).withPreview(Previews.SQUIRREL_GIRL)).with("content", content.getContent())).withUrlPath(this.getApiTail() + "/reactions", new String[0])).fetch(GHReaction.class).wrap(this.owner.root);
    }

    @Override
    @Preview(value={Previews.SQUIRREL_GIRL})
    public PagedIterable<GHReaction> listReactions() {
        return ((Requester)((Requester)this.owner.root.createRequest().withPreview(Previews.SQUIRREL_GIRL)).withUrlPath(this.getApiTail() + "/reactions", new String[0])).toIterable(GHReaction[].class, item -> item.wrap(this.owner.root));
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.owner.root.createRequest().method("DELETE")).withUrlPath(this.getApiTail(), new String[0])).send();
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/comments/%s", this.owner.getOwnerName(), this.owner.getName(), this.getId());
    }

    GHCommitComment wrap(GHRepository owner) {
        this.owner = owner;
        if (owner.root.isOffline()) {
            this.user.wrapUp(owner.root);
        }
        return this;
    }
}

