@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  TerasologyLauncher startup script for Windows
@rem
@rem This script has been adjusted to use a Java runtime local to the APP_HOME.
@rem
@rem https://github.com/gradle/gradle/blob/v6.8.2/subprojects/plugins/src/main/resources/org/gradle/api/internal/plugins/windowsStartScript.txt
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and TERASOLOGY_LAUNCHER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Use bundled JRE when available
if exist "%APP_HOME%/jre/" set JAVA_HOME="%APP_HOME%/jre/"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\TerasologyLauncher.jar;%APP_HOME%\lib\logback-classic-1.3.0-alpha5.jar;%APP_HOME%\lib\slf4j-api-2.0.0-alpha1.jar;%APP_HOME%\lib\gson-2.8.5.jar;%APP_HOME%\lib\guava-28.1-jre.jar;%APP_HOME%\lib\org.everit.json.schema-1.12.1.jar;%APP_HOME%\lib\github-api-1.131.jar;%APP_HOME%\lib\semver4j-3.1.0.jar;%APP_HOME%\lib\flexmark-all-0.62.2.jar;%APP_HOME%\lib\javafx-fxml-12.0.1-linux.jar;%APP_HOME%\lib\javafx-web-12.0.1-linux.jar;%APP_HOME%\lib\javafx-controls-12.0.1-linux.jar;%APP_HOME%\lib\javafx-controls-12.0.1.jar;%APP_HOME%\lib\javafx-media-12.0.1-linux.jar;%APP_HOME%\lib\javafx-media-12.0.1.jar;%APP_HOME%\lib\javafx-graphics-12.0.1-linux.jar;%APP_HOME%\lib\javafx-graphics-12.0.1.jar;%APP_HOME%\lib\javafx-base-12.0.1-linux.jar;%APP_HOME%\lib\javafx-base-12.0.1.jar;%APP_HOME%\lib\logback-core-1.3.0-alpha5.jar;%APP_HOME%\lib\javax.mail-1.6.2.jar;%APP_HOME%\lib\checker-framework-1.7.0.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\checker-qual-2.8.1.jar;%APP_HOME%\lib\error_prone_annotations-2.3.2.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.18.jar;%APP_HOME%\lib\json-20190722.jar;%APP_HOME%\lib\commons-validator-1.6.jar;%APP_HOME%\lib\handy-uri-templates-2.1.8.jar;%APP_HOME%\lib\re2j-1.3.jar;%APP_HOME%\lib\commons-lang3-3.9.jar;%APP_HOME%\lib\jackson-annotations-2.12.3.jar;%APP_HOME%\lib\jackson-core-2.12.3.jar;%APP_HOME%\lib\jackson-databind-2.12.3.jar;%APP_HOME%\lib\commons-io-2.8.0.jar;%APP_HOME%\lib\flexmark-profile-pegdown-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-abbreviation-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-admonition-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-anchorlink-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-aside-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-enumerated-reference-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-attributes-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-autolink-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-definition-0.62.2.jar;%APP_HOME%\lib\flexmark-html2md-converter-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-emoji-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-escaped-character-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-footnotes-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-gfm-issues-0.62.2.jar;%APP_HOME%\lib\flexmark-jira-converter-0.62.2.jar;%APP_HOME%\lib\flexmark-youtrack-converter-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-gfm-strikethrough-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-gfm-tasklist-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-gfm-users-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-macros-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-gitlab-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-jekyll-front-matter-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-jekyll-tag-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-media-tags-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-ins-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-xwiki-macros-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-superscript-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-tables-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-toc-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-typographic-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-wikilink-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-yaml-front-matter-0.62.2.jar;%APP_HOME%\lib\flexmark-ext-youtube-embedded-0.62.2.jar;%APP_HOME%\lib\flexmark-pdf-converter-0.62.2.jar;%APP_HOME%\lib\flexmark-0.62.2.jar;%APP_HOME%\lib\flexmark-util-0.62.2.jar;%APP_HOME%\lib\flexmark-util-format-0.62.2.jar;%APP_HOME%\lib\flexmark-util-ast-0.62.2.jar;%APP_HOME%\lib\flexmark-util-builder-0.62.2.jar;%APP_HOME%\lib\flexmark-util-dependency-0.62.2.jar;%APP_HOME%\lib\flexmark-util-html-0.62.2.jar;%APP_HOME%\lib\flexmark-util-options-0.62.2.jar;%APP_HOME%\lib\flexmark-util-sequence-0.62.2.jar;%APP_HOME%\lib\flexmark-util-collection-0.62.2.jar;%APP_HOME%\lib\flexmark-util-data-0.62.2.jar;%APP_HOME%\lib\flexmark-util-misc-0.62.2.jar;%APP_HOME%\lib\flexmark-util-visitor-0.62.2.jar;%APP_HOME%\lib\activation-1.1.jar;%APP_HOME%\lib\commons-digester-1.8.1.jar;%APP_HOME%\lib\openhtmltopdf-pdfbox-1.0.0.jar;%APP_HOME%\lib\graphics2d-0.24.jar;%APP_HOME%\lib\pdfbox-2.0.16.jar;%APP_HOME%\lib\xmpbox-2.0.16.jar;%APP_HOME%\lib\fontbox-2.0.16.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\commons-collections-3.2.2.jar;%APP_HOME%\lib\joda-time-2.10.2.jar;%APP_HOME%\lib\autolink-0.6.0.jar;%APP_HOME%\lib\openhtmltopdf-jsoup-dom-converter-1.0.0.jar;%APP_HOME%\lib\jsoup-1.11.3.jar;%APP_HOME%\lib\openhtmltopdf-rtl-support-1.0.0.jar;%APP_HOME%\lib\openhtmltopdf-core-1.0.0.jar;%APP_HOME%\lib\annotations-15.0.jar;%APP_HOME%\lib\icu4j-59.1.jar


@rem Execute TerasologyLauncher
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %TERASOLOGY_LAUNCHER_OPTS%  -classpath "%CLASSPATH%" org.terasology.launcher.TerasologyLauncher %*

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable TERASOLOGY_LAUNCHER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%TERASOLOGY_LAUNCHER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega