/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.game;

import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import javafx.concurrent.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.game.GameStarter;
import org.terasology.launcher.game.Installation;
import org.terasology.launcher.game.RunGameTask;
import org.terasology.launcher.settings.LauncherSettings;

public class GameService
extends Service<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(GameService.class);
    private Installation gamePath;
    private LauncherSettings settings;

    public GameService() {
        this.setExecutor(Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("GameService-%d").setDaemon(true).setUncaughtExceptionHandler(this::exceptionHandler).build()));
    }

    public void start(Installation installation, LauncherSettings settings) {
        this.gamePath = installation;
        this.settings = settings;
        this.start();
    }

    public void start() {
        super.start();
    }

    public boolean cancel() {
        throw new UnsupportedOperationException("GameService does not cancel.");
    }

    public void restart() {
        super.restart();
    }

    protected RunGameTask createTask() {
        GameStarter starter;
        Verify.verifyNotNull((Object)this.settings);
        ArrayList javaParameters = Lists.newArrayList();
        javaParameters.addAll(this.settings.getJavaParameterList());
        ArrayList gameParameters = Lists.newArrayList();
        gameParameters.addAll(this.settings.getUserGameParameterList());
        try {
            starter = new GameStarter((Installation)Verify.verifyNotNull((Object)this.gamePath), this.settings.getGameDataDirectory(), this.settings.getInitialHeapSize(), this.settings.getMaxHeapSize(), javaParameters, gameParameters, this.settings.getLogLevel());
        }
        catch (IOException e) {
            throw new RuntimeException("Error using this as a game directory: " + this.gamePath, e);
        }
        return new RunGameTask(starter);
    }

    protected void succeeded() {
        this.reset();
    }

    protected void failed() {
        Throwable error = this.getException();
        if (error != null) {
            this.exceptionHandler(Thread.currentThread(), error);
        }
        this.reset();
    }

    private void exceptionHandler(Thread thread, Throwable thrown) {
        logger.error("Unhandled exception", thrown);
    }
}

