/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.game;

import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.terasology.launcher.game.Installation;
import org.terasology.launcher.game.VersionHistory;
import org.terasology.launcher.util.JavaHeapSize;
import org.terasology.launcher.util.Platform;

class GameStarter
implements Callable<Process> {
    private static final Logger logger = LoggerFactory.getLogger(GameStarter.class);
    final ProcessBuilder processBuilder;
    private final Semver engineVersion;

    GameStarter(Installation installation, Path gameDataDirectory, JavaHeapSize heapMin, JavaHeapSize heapMax, List<String> javaParams, List<String> gameParams, Level logLevel) throws IOException {
        this.engineVersion = installation.getEngineVersion();
        Path gamePath = installation.path;
        boolean isMac = Platform.getPlatform().isMac();
        ArrayList<String> processParameters = new ArrayList<String>();
        processParameters.add(this.getRuntimePath().toString());
        if (heapMin.isUsed()) {
            processParameters.add("-Xms" + heapMin.getSizeParameter());
        }
        if (heapMax.isUsed()) {
            processParameters.add("-Xmx" + heapMax.getSizeParameter());
        }
        processParameters.add("-DlogOverrideLevel=" + logLevel.name());
        if (isMac && VersionHistory.LWJGL3.isProvidedBy(this.engineVersion)) {
            processParameters.add("-XstartOnFirstThread");
            processParameters.add("-Djava.awt.headless=true");
        }
        processParameters.addAll(javaParams);
        processParameters.add("-jar");
        processParameters.add(installation.getGameJarPath().toString());
        processParameters.add(this.homeDirParameter(gameDataDirectory));
        processParameters.addAll(gameParams);
        if (isMac) {
            processParameters.add(this.noSplashParameter());
        }
        this.processBuilder = new ProcessBuilder(processParameters).directory(gamePath.toFile()).redirectErrorStream(true);
    }

    @Override
    public Process call() throws IOException {
        logger.info("Starting game with: {}", (Object)String.join((CharSequence)" ", this.processBuilder.command()));
        return this.processBuilder.start();
    }

    Path getRuntimePath() {
        return Paths.get(System.getProperty("java.home"), "bin", "java");
    }

    String homeDirParameter(Path gameDataDirectory) {
        if (this.terasologyUsesPosixOptions()) {
            return "--homedir=" + gameDataDirectory.toAbsolutePath();
        }
        return "-homedir=" + gameDataDirectory.toAbsolutePath();
    }

    String noSplashParameter() {
        return this.terasologyUsesPosixOptions() ? "--no-splash" : "-noSplash";
    }

    boolean terasologyUsesPosixOptions() {
        return VersionHistory.PICOCLI.isProvidedBy(this.engineVersion);
    }
}

