/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.log;

import ch.qos.logback.core.PropertyDefinerBase;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TempLogFilePropertyDefiner
extends PropertyDefinerBase {
    private static TempLogFilePropertyDefiner instance;
    private Path logFile;
    private String prefix;
    private String suffix;
    private boolean failed;

    public TempLogFilePropertyDefiner() {
        if (instance != null) {
            throw new IllegalStateException("This class must not be instantiated twice");
        }
        instance = this;
    }

    public static TempLogFilePropertyDefiner getInstance() {
        return instance;
    }

    public String getPropertyValue() {
        if (this.failed) {
            return null;
        }
        return this.getLogFile().toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Path getLogFile() {
        if (this.logFile == null) {
            try {
                this.logFile = Files.createTempFile(this.prefix, this.suffix, new FileAttribute[0]);
                System.out.println("Using log file " + this.logFile);
            }
            catch (IOException e) {
                this.failed = true;
                e.printStackTrace();
            }
        }
        return this.logFile;
    }
}

