/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.model.Build;
import org.terasology.launcher.model.Profile;

public class GameIdentifier {
    private static final Logger logger = LoggerFactory.getLogger(GameIdentifier.class);
    final String displayVersion;
    final Build build;
    final Profile profile;

    public GameIdentifier(String displayVersion, Build build, Profile profile) {
        this.displayVersion = displayVersion;
        this.build = build;
        this.profile = profile;
    }

    public String getDisplayVersion() {
        return this.displayVersion;
    }

    public Build getBuild() {
        return this.build;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GameIdentifier that = (GameIdentifier)o;
        return this.displayVersion.equals(that.displayVersion) && this.build == that.build && this.profile == that.profile;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.displayVersion, this.build, this.profile});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.displayVersion).add("build", (Object)this.build).add("profile", (Object)this.profile).toString();
    }
}

