/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.repositories;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.terasology.launcher.model.Build;
import org.terasology.launcher.model.GameRelease;
import org.terasology.launcher.model.Profile;
import org.terasology.launcher.repositories.GithubRepositoryAdapter;
import org.terasology.launcher.repositories.JenkinsClient;
import org.terasology.launcher.repositories.JenkinsRepositoryAdapter;
import org.terasology.launcher.repositories.ReleaseRepository;

public class RepositoryManager {
    private final Set<GameRelease> releases;

    public RepositoryManager() {
        JenkinsClient client = new JenkinsClient(new Gson());
        JenkinsRepositoryAdapter omegaNightly = new JenkinsRepositoryAdapter(Profile.OMEGA, Build.NIGHTLY, client);
        GithubRepositoryAdapter github = new GithubRepositoryAdapter();
        HashSet all = Sets.newHashSet((Object[])new ReleaseRepository[]{github, omegaNightly});
        this.releases = this.fetchReleases(all);
    }

    private Set<GameRelease> fetchReleases(Set<ReleaseRepository> repositories) {
        return repositories.parallelStream().map(ReleaseRepository::fetchReleases).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<GameRelease> getReleases() {
        return this.releases;
    }
}

