/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.settings;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.terasology.launcher.model.GameIdentifier;
import org.terasology.launcher.util.JavaHeapSize;

public abstract class LauncherSettings {
    private static final Logger logger = LoggerFactory.getLogger(LauncherSettings.class);

    abstract Properties getProperties();

    public synchronized void init() {
        logger.trace("Init launcher settings ...");
        this.initLocale();
        this.initMaxHeapSize();
        this.initInitialHeapSize();
        this.initBaseJavaParameters();
        this.initCloseLauncherAfterGameStart();
        this.initSaveDownloadedFiles();
        this.initShowPreReleases();
        this.initGameDirectory();
        this.initGameDataDirectory();
        this.initUserJavaParameters();
        this.initUserGameParameters();
        this.initLogLevel();
        this.initLastPlayedGameVersion();
        this.initLastInstalledGameVersion();
    }

    protected abstract void initInitialHeapSize();

    protected abstract void initCloseLauncherAfterGameStart();

    protected abstract void initSaveDownloadedFiles();

    protected abstract void initShowPreReleases();

    protected abstract void initGameDirectory();

    protected abstract void initGameDataDirectory();

    protected abstract void initBaseJavaParameters();

    protected abstract void initUserJavaParameters();

    protected abstract void initUserGameParameters();

    protected abstract void initLogLevel();

    protected abstract void initMaxHeapSize();

    protected abstract void initLocale();

    protected abstract void initLastPlayedGameVersion();

    protected abstract void initLastInstalledGameVersion();

    public abstract ReadOnlyProperty<Boolean> showPreReleases();

    public abstract Locale getLocale();

    public abstract JavaHeapSize getMaxHeapSize();

    public abstract JavaHeapSize getInitialHeapSize();

    public abstract String getUserJavaParameters();

    public abstract String getBaseJavaParameters();

    public synchronized List<String> getJavaParameterList() {
        String userParams;
        ArrayList javaParameters = Lists.newArrayList();
        String baseParams = this.getBaseJavaParameters();
        if (baseParams != null) {
            javaParameters.addAll(Arrays.asList(baseParams.split("\\s+")));
        }
        if ((userParams = this.getUserJavaParameters()) != null) {
            javaParameters.addAll(Arrays.asList(userParams.split("\\s+")));
        }
        return javaParameters;
    }

    public abstract String getUserGameParameters();

    public synchronized List<String> getUserGameParameterList() {
        return Arrays.stream(this.getUserGameParameters().split("\\s+")).filter(s -> !s.isEmpty()).collect(Collectors.toUnmodifiableList());
    }

    public abstract Level getLogLevel();

    public abstract Path getGameDirectory();

    public abstract Path getGameDataDirectory();

    public abstract boolean isCloseLauncherAfterGameStart();

    public abstract boolean isKeepDownloadedFiles();

    public abstract boolean isShowPreReleases();

    public abstract Optional<GameIdentifier> getLastPlayedGameVersion();

    public abstract String getLastInstalledGameJob();

    public abstract void setLocale(Locale var1);

    public abstract void setMaxHeapSize(JavaHeapSize var1);

    public abstract void setInitialHeapSize(JavaHeapSize var1);

    public abstract void setUserJavaParameters(String var1);

    public abstract void setUserGameParameters(String var1);

    public abstract void setLogLevel(Level var1);

    public abstract void setCloseLauncherAfterGameStart(boolean var1);

    public abstract void setKeepDownloadedFiles(boolean var1);

    public abstract void setShowPreReleases(boolean var1);

    public abstract void setGameDirectory(Path var1);

    public abstract void setGameDataDirectory(Path var1);

    public abstract void setDefaultGameJob(String var1);

    public abstract void setLastPlayedGameVersion(GameIdentifier var1);
}

