/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.settings.BaseLauncherSettings;
import org.terasology.launcher.settings.LauncherSettings;

public final class Settings {
    public static final String DEFAULT_FILE_NAME = "TerasologyLauncherSettings.properties";
    private static final Logger logger = LoggerFactory.getLogger(Settings.class);
    private static final String COMMENT_SETTINGS = "Terasology Launcher - Settings";

    private Settings() {
    }

    public static LauncherSettings load(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            BaseLauncherSettings baseLauncherSettings;
            block9: {
                logger.debug("Loading launcher settings from '{}'.", (Object)path);
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    baseLauncherSettings = new BaseLauncherSettings(properties);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("Error while loading launcher settings from file.", e);
                    }
                }
                inputStream.close();
            }
            return baseLauncherSettings;
        }
        return null;
    }

    public static synchronized void store(LauncherSettings settings, Path path) throws IOException {
        logger.debug("Writing launcher settings to '{}'.", (Object)path);
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            settings.getProperties().store(outputStream, COMMENT_SETTINGS);
        }
    }

    public static LauncherSettings getDefault() {
        return new BaseLauncherSettings(new Properties());
    }
}

