/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.tasks;

import java.io.IOException;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.game.GameManager;
import org.terasology.launcher.model.GameRelease;
import org.terasology.launcher.tasks.ProgressListener;
import org.terasology.launcher.util.DownloadException;

public final class DownloadTask
extends Task<Void>
implements ProgressListener {
    private static final Logger logger = LoggerFactory.getLogger(DownloadTask.class);
    private final GameManager gameManager;
    private final GameRelease release;

    public DownloadTask(GameManager gameManager, GameRelease release) {
        this.gameManager = gameManager;
        this.release = release;
    }

    protected Void call() throws InterruptedException {
        try {
            this.gameManager.install(this.release, this);
        }
        catch (IOException | DownloadException e) {
            logger.error("Failed to download package '{}' from '{}'", this.release.getId(), this.release.getUrl(), e);
        }
        return null;
    }

    @Override
    public void update() {
    }

    @Override
    public void update(int progress) {
        this.updateProgress(progress, 100L);
    }
}

