/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.ui;

import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.Arrays;
import javafx.fxml.FXML;
import javafx.scene.effect.BlendMode;
import javafx.scene.web.WebView;
import org.terasology.launcher.util.BundleUtils;

public class ChangelogViewController {
    @FXML
    private WebView changelogView;
    private HtmlRenderer renderer;
    private Parser parser;

    public ChangelogViewController() {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(EmojiExtension.create()));
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    void update(String changes) {
        this.changelogView.getEngine().loadContent(this.makeHtml(changes));
        this.changelogView.setBlendMode(BlendMode.LIGHTEN);
        this.changelogView.getEngine().setUserStyleSheetLocation(BundleUtils.getFXMLUrl("css_webview").toExternalForm());
    }

    private String makeHtml(String changes) {
        Document document = this.parser.parse(changes);
        return this.renderer.render((Node)document);
    }
}

