/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.updater;

import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.model.LauncherVersion;
import org.terasology.launcher.util.BundleUtils;

public final class LauncherUpdater {
    private static final Logger logger = LoggerFactory.getLogger(LauncherUpdater.class);
    private final Semver currentVersion;

    public LauncherUpdater(LauncherVersion currentVersionInfo) {
        this.currentVersion = currentVersionInfo.getSemver();
    }

    private Semver versionOf(GHRelease release) {
        return new Semver(release.getTagName().replaceAll("^v(.*)$", "$1"));
    }

    public GHRelease updateAvailable() {
        try {
            GitHub github = GitHub.connectAnonymously();
            GHRepository repository = github.getRepository("MovingBlocks/TerasologyLauncher");
            GHRelease latestRelease = repository.getLatestRelease();
            Semver latestVersion = this.versionOf(latestRelease);
            if (latestVersion.isGreaterThan(this.currentVersion)) {
                return latestRelease;
            }
        }
        catch (IOException e) {
            logger.warn("Update check failed: {}", (Object)e.getMessage());
        }
        return null;
    }

    public boolean showUpdateDialog(Stage parentStage, GHRelease release) {
        FutureTask<Boolean> dialog = this.getUpdateDialog(parentStage, release);
        Platform.runLater(dialog);
        boolean result = false;
        try {
            result = dialog.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Uh oh, something went wrong with the update dialog!", e);
        }
        return result;
    }

    private FutureTask<Boolean> getUpdateDialog(Stage parentStage, GHRelease release) {
        String infoText = "  " + BundleUtils.getLabel("message_update_current") + "  " + this.currentVersion.getValue() + "  \n  " + BundleUtils.getLabel("message_update_latest") + "  " + this.versionOf(release).getValue() + "  ";
        return new FutureTask<Boolean>(() -> {
            Parent root = (Parent)BundleUtils.getFXMLLoader("update_dialog").load();
            ((TextArea)root.lookup("#infoTextArea")).setText(infoText);
            ((TextArea)root.lookup("#changelogTextArea")).setText(release.getBody());
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle(BundleUtils.getLabel("message_update_launcher_title"));
            alert.setHeaderText(BundleUtils.getLabel("message_update_launcher"));
            alert.getDialogPane().setContent((Node)root);
            alert.initOwner((Window)parentStage);
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
            alert.initModality(Modality.APPLICATION_MODAL);
            alert.setResizable(true);
            return alert.showAndWait().filter(response -> response == ButtonType.YES).isPresent();
        });
    }
}

