/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.util.Languages;

public final class BundleUtils {
    private static final Logger logger = LoggerFactory.getLogger(BundleUtils.class);
    private static final String LABELS_BUNDLE = "org.terasology.launcher.bundle.LabelsBundle";
    private static final String MESSAGE_BUNDLE = "org.terasology.launcher.bundle.MessageBundle";
    private static final String URI_BUNDLE = "org.terasology.launcher.bundle.URIBundle";
    private static final String IMAGE_BUNDLE = "org.terasology.launcher.bundle.ImageBundle";
    private static final String FXML_BUNDLE = "org.terasology.launcher.bundle.FXMLBundle";

    private BundleUtils() {
    }

    public static String getLabel(String key) {
        return BundleUtils.getLabel(Languages.getCurrentLocale(), key);
    }

    public static String getLabel(Locale locale, String key) {
        try {
            String label = ResourceBundle.getBundle(LABELS_BUNDLE, locale).getString(key);
            if (label.length() == 0) {
                throw new IllegalArgumentException();
            }
            return label;
        }
        catch (IllegalArgumentException | MissingResourceException e) {
            logger.error("Missing label translation! key={}, locale={}", (Object)key, (Object)locale);
            return ResourceBundle.getBundle(LABELS_BUNDLE, Languages.DEFAULT_LOCALE).getString(key);
        }
    }

    public static String getMessage(String key, Object ... arguments) {
        String pattern;
        try {
            pattern = ResourceBundle.getBundle(MESSAGE_BUNDLE, Languages.getCurrentLocale()).getString(key);
            if (pattern.length() == 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException | MissingResourceException e) {
            logger.error("Missing message translation! key={}, locale={}", (Object)key, (Object)Languages.getCurrentLocale());
            pattern = ResourceBundle.getBundle(MESSAGE_BUNDLE, Languages.DEFAULT_LOCALE).getString(key);
        }
        MessageFormat messageFormat = new MessageFormat(pattern, Languages.getCurrentLocale());
        return messageFormat.format(arguments, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static URI getURI(String key) {
        String uriStr = ResourceBundle.getBundle(URI_BUNDLE, Languages.getCurrentLocale()).getString(key);
        try {
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            logger.error("Could not create URI '{}' for key '{}'!", uriStr, key, e);
            return null;
        }
    }

    public static Image getFxImage(String key) throws MissingResourceException {
        String imagePath = ResourceBundle.getBundle(IMAGE_BUNDLE, Languages.getCurrentLocale()).getString(key);
        return new Image(BundleUtils.class.getResource(imagePath).toExternalForm());
    }

    public static FXMLLoader getFXMLLoader(String key) {
        return new FXMLLoader(BundleUtils.getFXMLUrl(key), ResourceBundle.getBundle(LABELS_BUNDLE, Languages.getCurrentLocale()));
    }

    public static URL getFXMLUrl(String key) {
        String url = ResourceBundle.getBundle(FXML_BUNDLE, Languages.getCurrentLocale()).getString(key);
        return BundleUtils.class.getResource(url);
    }

    public static URL getFXMLUrl(String key, String relative) {
        String url = ResourceBundle.getBundle(FXML_BUNDLE, Languages.getCurrentLocale()).getString(key);
        return BundleUtils.class.getResource(url + "/" + relative);
    }

    public static String getStylesheet(String key) {
        return ResourceBundle.getBundle(FXML_BUNDLE, Languages.getCurrentLocale()).getString(key);
    }
}

