/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.launcher.util.visitor.ArchiveCopyVisitor;
import org.terasology.launcher.util.visitor.DeleteFileVisitor;
import org.terasology.launcher.util.visitor.LocalCopyVisitor;

public final class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static void delete(Path path) throws IOException {
        Files.walkFileTree(path, new DeleteFileVisitor());
    }

    public static void deleteFileSilently(Path file) {
        try {
            boolean deleted = Files.deleteIfExists(file);
            if (!deleted) {
                logger.error("Could not silently delete file '{}'!", (Object)file);
            }
        }
        catch (IOException e) {
            logger.error("Could not silently delete file '{}'!", (Object)file, (Object)e);
        }
    }

    static void deleteDirectoryContent(Path directory) throws IOException {
        try (Stream<Path> stream = Files.list(directory);){
            stream.forEach(path -> {
                try {
                    Files.walkFileTree(path, new DeleteFileVisitor());
                }
                catch (IOException e) {
                    logger.error("Failed to delete '{}'", path, (Object)e);
                }
            });
        }
    }

    public static boolean extractZipTo(Path archive, Path outputLocation) {
        logger.trace("Extracting '{}' to '{}'", (Object)archive, (Object)outputLocation);
        try {
            if (Files.notExists(outputLocation, new LinkOption[0])) {
                Files.createDirectories(outputLocation, new FileAttribute[0]);
            }
            try (FileSystem fileSystem = FileSystems.newFileSystem(archive, (ClassLoader)null);){
                for (Path rootDirectory : fileSystem.getRootDirectories()) {
                    Files.walkFileTree(rootDirectory, new ArchiveCopyVisitor(outputLocation));
                }
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Could not extract zip archive '{}' to '{}'!", archive, outputLocation, e);
            return false;
        }
    }

    public static void copyFolder(Path source, Path destination) throws IOException {
        if (Files.notExists(source, new LinkOption[0])) {
            logger.error("Source file doesn't exists! '{}'", (Object)source);
            return;
        }
        Files.walkFileTree(source, new LocalCopyVisitor(source, destination));
    }

    public static void ensureEmptyDir(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        } else {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                throw new IOException("Directory is not a directory! " + directory);
            }
            FileUtils.deleteDirectoryContent(directory);
        }
    }

    public static boolean isReadableDir(Path path) {
        return path != null && Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path);
    }

    public static void ensureWritableDir(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IOException("Not a directory: " + directory);
        }
        if (!Files.isReadable(directory) || !Files.isWritable(directory)) {
            throw new IOException("Missing read or write permissions: " + directory);
        }
    }
}

