/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Languages {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final List<Locale> SUPPORTED_LOCALES;
    public static final Map<Locale, String> SETTINGS_LABEL_KEYS;
    private static Locale currentLocale;
    private static final Logger logger;

    private Languages() {
    }

    public static void init(String localeString) {
        for (Locale locale : SUPPORTED_LOCALES) {
            if (!locale.toString().equals(localeString)) continue;
            currentLocale = locale;
            break;
        }
    }

    public static void init() {
        Locale defaultLocale = Locale.getDefault();
        for (Locale locale : SUPPORTED_LOCALES) {
            if (!locale.getLanguage().equals(defaultLocale.getLanguage())) continue;
            if (logger.isDebugEnabled() && !locale.equals(currentLocale)) {
                logger.debug("An appropriate locale has been found '{}'. Change the current locale from '{}' to '{}'.", defaultLocale, currentLocale, locale);
            }
            currentLocale = locale;
            break;
        }
    }

    public static void update(Locale newLocale) {
        if (SUPPORTED_LOCALES.contains(newLocale)) {
            currentLocale = newLocale;
        } else {
            logger.warn("Unsupported locale '{}'.", (Object)newLocale);
        }
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    static {
        Locale czech = new Locale("cs");
        Locale spanish = new Locale("es");
        Locale french = new Locale("fr");
        Locale galician = new Locale("gl");
        Locale italian = new Locale("it");
        Locale lithuanian = new Locale("lt");
        Locale polish = new Locale("pl");
        Locale russian = new Locale("ru");
        Locale turkish = new Locale("tr");
        Locale ukrainian = new Locale("uk");
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        supportedLocales.add(Locale.GERMAN);
        supportedLocales.add(Locale.ENGLISH);
        supportedLocales.add(spanish);
        supportedLocales.add(french);
        supportedLocales.add(galician);
        supportedLocales.add(italian);
        supportedLocales.add(Locale.JAPANESE);
        supportedLocales.add(lithuanian);
        supportedLocales.add(polish);
        supportedLocales.add(russian);
        supportedLocales.add(turkish);
        supportedLocales.add(ukrainian);
        supportedLocales.add(czech);
        Comparator comparator = (o1, o2) -> o1.toString().compareTo(o2.toString());
        TreeMap<Locale, String> settingsLabelKey = new TreeMap<Locale, String>(comparator);
        settingsLabelKey.put(Locale.GERMAN, "settings_language_de");
        settingsLabelKey.put(Locale.ENGLISH, "settings_language_en");
        settingsLabelKey.put(spanish, "settings_language_es");
        settingsLabelKey.put(french, "settings_language_fr");
        settingsLabelKey.put(galician, "settings_language_gl");
        settingsLabelKey.put(italian, "settings_language_it");
        settingsLabelKey.put(Locale.JAPANESE, "settings_language_ja");
        settingsLabelKey.put(lithuanian, "settings_language_lt");
        settingsLabelKey.put(polish, "settings_language_pl");
        settingsLabelKey.put(russian, "settings_language_ru");
        settingsLabelKey.put(turkish, "settings_language_tr");
        settingsLabelKey.put(ukrainian, "settings_language_uk");
        settingsLabelKey.put(czech, "settings_language_cs");
        Collections.sort(supportedLocales, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        SUPPORTED_LOCALES = supportedLocales;
        SETTINGS_LABEL_KEYS = settingsLabelKey;
        currentLocale = DEFAULT_LOCALE;
        logger = LoggerFactory.getLogger(Languages.class);
    }
}

