/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util;

import java.nio.file.Path;
import org.terasology.launcher.util.DirectoryCreator;
import org.terasology.launcher.util.FileUtils;

public enum LauncherManagedDirectory {
    TEMP(FileUtils::ensureEmptyDir, FileUtils::ensureWritableDir),
    CACHE(FileUtils::ensureWritableDir),
    DOWNLOAD(FileUtils::ensureWritableDir),
    GAMES(FileUtils::ensureWritableDir);

    private final DirectoryCreator[] creators;
    private final String errorLabel;
    private final String directoryName;

    private LauncherManagedDirectory(DirectoryCreator ... creators) {
        this.creators = creators;
        this.errorLabel = String.format("message_error_{}Directory", this.name().toLowerCase());
        this.directoryName = this.name().toLowerCase();
    }

    public DirectoryCreator[] getCreators() {
        return this.creators;
    }

    public String getErrorLabel() {
        return this.errorLabel;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public Path getDirectoryPath(Path launcherInstallationPath) {
        return launcherInstallationPath.resolve(this.getDirectoryName());
    }
}

