/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.launcher.util.visitor;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class ArchiveCopyVisitor
extends SimpleFileVisitor<Path> {
    private final Path targetLocation;

    public ArchiveCopyVisitor(Path targetLocation) {
        this.targetLocation = targetLocation;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path destFile = Paths.get(this.targetLocation.toString() + file.toString(), new String[0]);
        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path dirToCreate = Paths.get(this.targetLocation.toString() + dir.toString(), new String[0]);
        if (Files.notExists(dirToCreate, new LinkOption[0])) {
            Files.createDirectories(dirToCreate, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }
}

