/*                             Comb.h
 * BRL-CAD
 *
 * Copyright (c) 2013-2021 United States Government as represented by
 * the U.S. Army Research Laboratory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this file; see the file named COPYING for more
 * information.
 */
/** @file step/Comb_Tree.h
 *
 */

#ifndef COMB_H
#define COMB_H

#include "AP_Common.h"

void
Comb_to_STEP(struct directory *dp,
	AP203_Contents *sc,
	STEPentity **shape,
	STEPentity **product);

struct directory *
Comb_Get_Only_Child(struct directory *dp, struct rt_wdb *wdbp);

int
Comb_Is_Wrapper(struct directory *dp, struct rt_wdb *wdbp);

#endif /* COMB_H */
/*
 * Local Variables:
 * tab-width: 8
 * mode: C
 * indent-tabs-mode: t
 * c-file-style: "stroustrup"
 * End:
 * ex: shiftwidth=4 tabstop=8
 */
