/*                    O B J _ P R E P . C
 * BRL-CAD
 *
 * Copyright (c) 2010-2021 United States Government as represented by
 * the U.S. Army Research Laboratory.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this file; see the file named COPYING for more
 * information.
 */

#include "common.h"

#include "raytrace.h"
#include "rt/func.h"


int
rt_obj_prep(struct soltab *stp, struct rt_db_internal *ip, struct rt_i *rtip)
{
    int id;
    const struct rt_functab *ft;

    if (!stp || !ip)
	return -1;

    RT_CK_SOLTAB(stp);
    RT_CK_DB_INTERNAL(ip);
    if (rtip) RT_CK_RTI(rtip);

    id = stp->st_id;
    if (id < 0)
	return -2;

    ft = &OBJ[id];
    if (!ft)
	return -3;
    if (!ft->ft_prep)
	return -4;

    return ft->ft_prep(stp, ip, rtip);
}


int
rt_obj_prep_serialize(struct soltab *stp, const struct rt_db_internal *ip, struct bu_external *external, size_t *version)
{
    const struct rt_functab *ft;

    if (!stp || !ip || !external || !version)
	return -1;

    RT_CK_SOLTAB(stp);
    RT_CK_DB_INTERNAL(ip);
    BU_CK_EXTERNAL(external);

    if (stp->st_id < 0)
	return -2;

    ft = &OBJ[stp->st_id];

    if (!ft)
	return -3;

    if (!ft->ft_prep_serialize)
	return -4;

    return ft->ft_prep_serialize(stp, ip, external, version);
}


/*
 * Local Variables:
 * mode: C
 * tab-width: 8
 * indent-tabs-mode: t
 * c-file-style: "stroustrup"
 * End:
 * ex: shiftwidth=4 tabstop=8
 */
