/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.GtkChildWindow;
import com.sun.glass.ui.gtk.GtkCommonDialogs;
import com.sun.glass.ui.gtk.GtkCursor;
import com.sun.glass.ui.gtk.GtkPixels;
import com.sun.glass.ui.gtk.GtkRobot;
import com.sun.glass.ui.gtk.GtkTimer;
import com.sun.glass.ui.gtk.GtkView;
import com.sun.glass.ui.gtk.GtkWindow;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.util.Logging;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import sun.util.logging.PlatformLogger;

final class GtkApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private static final String SWT_INTERNAL_CLASS = "org.eclipse.swt.internal.gtk.OS";
    private static final int forcedGtkVersion;
    public static int screen;
    public static long display;
    public static long visualID;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private static final int QUERY_ERROR = -2;
    private static final int QUERY_NO_DISPLAY = -1;
    private static final int QUERY_USE_CURRENT = 1;
    private static final int QUERY_LOAD_GTK2 = 2;
    private static final int QUERY_LOAD_GTK3 = 3;
    private Object eventLoopExitEnterPassValue;

    GtkApplication() {
        int gtkVersion = forcedGtkVersion == 0 ? AccessController.doPrivileged(() -> {
            String v = System.getProperty("jdk.gtk.version", "2");
            int ret = 0;
            if ("3".equals(v) || v.startsWith("3.")) {
                ret = 3;
            } else if ("2".equals(v) || v.startsWith("2.")) {
                ret = 2;
            }
            return ret;
        }) : forcedGtkVersion;
        boolean gtkVersionVerbose = AccessController.doPrivileged(() -> Boolean.getBoolean("jdk.gtk.verbose"));
        int libraryToLoad = GtkApplication._queryLibrary(gtkVersion, gtkVersionVerbose);
        AccessController.doPrivileged(() -> {
            if (libraryToLoad == -1) {
                throw new UnsupportedOperationException("Unable to open DISPLAY");
            }
            if (libraryToLoad == 1) {
                if (gtkVersionVerbose) {
                    System.out.println("Glass GTK library to load is already loaded");
                }
            } else if (libraryToLoad == 2) {
                if (gtkVersionVerbose) {
                    System.out.println("Glass GTK library to load is glassgtk2");
                }
                NativeLibLoader.loadLibrary("glassgtk2");
            } else if (libraryToLoad == 3) {
                if (gtkVersionVerbose) {
                    System.out.println("Glass GTK library to load is glassgtk3");
                }
                NativeLibLoader.loadLibrary("glassgtk3");
            } else {
                throw new UnsupportedOperationException("Internal Error");
            }
            return null;
        });
        int version = GtkApplication._initGTK(gtkVersion, gtkVersionVerbose);
        if (version == -1) {
            throw new RuntimeException("Error loading GTK libraries");
        }
        boolean isEventThread = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (!isEventThread) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    private static native int _queryLibrary(int var0, boolean var1);

    private static native int _initGTK(int var0, boolean var1);

    private void initDisplay() {
        Map ds = GtkApplication.getDeviceDetails();
        if (ds != null) {
            Object value = ds.get("XDisplay");
            if (value != null) {
                display = (Long)value;
            }
            if ((value = ds.get("XVisualID")) != null) {
                visualID = (Long)value;
            }
            if ((value = ds.get("XScreenID")) != null) {
                screen = (Integer)value;
            }
        }
    }

    private void init() {
        this.initDisplay();
        long eventProc = 0L;
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Long result = (Long)map.get("javafx.embed.eventProc");
            eventProc = result == null ? 0L : result;
        }
        boolean disableGrab = AccessController.doPrivileged(() -> Boolean.getBoolean("sun.awt.disablegrab") || Boolean.getBoolean("glass.disableGrab"));
        this._init(eventProc, disableGrab);
    }

    @Override
    protected void runLoop(Runnable launchable) {
        boolean isEventThread = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (isEventThread) {
            this.init();
            GtkApplication.setEventThread(Thread.currentThread());
            launchable.run();
            return;
        }
        boolean noErrorTrap = AccessController.doPrivileged(() -> Boolean.getBoolean("glass.noErrorTrap"));
        Thread toolkitThread = AccessController.doPrivileged(() -> new Thread(() -> {
            this.init();
            this._runLoop(launchable, noErrorTrap);
        }, "GtkNativeMainLoopThread"));
        GtkApplication.setEventThread(toolkitThread);
        toolkitThread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread toolkitThread = GtkApplication.getEventThread();
        if (toolkitThread != null) {
            this._terminateLoop();
            GtkApplication.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native void _terminateLoop();

    private native void _init(long var1, boolean var3);

    private native void _runLoop(Runnable var1, boolean var2);

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeAndWait(runnable);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            this.submitForLaterInvocation(() -> {
                if (runnable != null) {
                    runnable.run();
                }
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable r) {
        this._submitForLaterInvocation(r);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    private native void enterNestedEventLoopImpl();

    private native void leaveNestedEventLoopImpl();

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            this.enterNestedEventLoopImpl();
            Object retValue = this.eventLoopExitEnterPassValue;
            this.eventLoopExitEnterPassValue = null;
            Object object = retValue;
            return object;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this.eventLoopExitEnterPassValue = retValue;
        this.leaveNestedEventLoopImpl();
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new GtkWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        return new GtkChildWindow(parent);
    }

    @Override
    public View createView() {
        return new GtkView();
    }

    @Override
    public Cursor createCursor(int type) {
        return new GtkCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new GtkCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return GtkCursor._getBestSize(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new GtkPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new GtkPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scale) {
        return new GtkPixels(width, height, data, scale);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public Robot createRobot() {
        return new GtkRobot();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new GtkTimer(runnable);
    }

    @Override
    protected native int staticTimer_getMinPeriod();

    @Override
    protected native int staticTimer_getMaxPeriod();

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters, int defaultFilterIndex) {
        return GtkCommonDialogs.showFileChooser(owner, folder, filename, title, type, multipleMode, extensionFilters, defaultFilterIndex);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return GtkCommonDialogs.showFolderChooser(owner, folder, title);
    }

    @Override
    protected native long staticView_getMultiClickTime();

    @Override
    protected native int staticView_getMultiClickMaxX();

    @Override
    protected native int staticView_getMultiClickMaxY();

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected native boolean _supportsTransparentWindows();

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1);

    static {
        Class OS2 = AccessController.doPrivileged(() -> {
            try {
                return Class.forName(SWT_INTERNAL_CLASS, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                try {
                    return Class.forName(SWT_INTERNAL_CLASS, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        });
        if (OS2 != null) {
            PlatformLogger logger = Logging.getJavaFXLogger();
            logger.fine("SWT-GTK library found. Try to obtain GTK version.");
            Method method = AccessController.doPrivileged(() -> {
                try {
                    return OS2.getMethod("gtk_major_version", new Class[0]);
                }
                catch (Exception e) {
                    return null;
                }
            });
            int ver = 0;
            if (method != null) {
                try {
                    ver = ((Number)method.invoke((Object)OS2, new Object[0])).intValue();
                }
                catch (Exception e) {
                    logger.warning("Method gtk_major_version() of the org.eclipse.swt.internal.gtk.OS class returns error. SWT GTK version cannot be detected. GTK3 will be used as default.");
                    ver = 3;
                }
            }
            if (ver < 2 || ver > 3) {
                logger.warning("SWT-GTK uses unsupported major GTK version " + ver + ". GTK3 will be used as default.");
                ver = 3;
            }
            forcedGtkVersion = ver;
        } else {
            forcedGtkVersion = 0;
        }
        AccessController.doPrivileged(() -> {
            Application.loadNativeLibrary();
            return null;
        });
        screen = -1;
        display = 0L;
        visualID = 0L;
    }
}

