/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.MetadataParser;
import com.sun.media.jfxmedia.events.MetadataListener;
import com.sun.media.jfxmedia.locator.Locator;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.image.Image;
import javafx.scene.media.AudioTrack;
import javafx.scene.media.MediaException;
import javafx.scene.media.SubtitleTrack;
import javafx.scene.media.Track;
import javafx.scene.media.VideoTrack;
import javafx.util.Duration;

public final class Media {
    private ReadOnlyObjectWrapper<MediaException> error;
    private ObjectProperty<Runnable> onError;
    private MetadataListener metadataListener = new _MetadataListener();
    private ObservableMap<String, Object> metadata;
    private final ObservableMap<String, Object> metadataBacking = FXCollections.observableMap(new HashMap());
    private ReadOnlyIntegerWrapper width;
    private ReadOnlyIntegerWrapper height;
    private ReadOnlyObjectWrapper<Duration> duration;
    private ObservableList<Track> tracks;
    private final ObservableList<Track> tracksBacking = FXCollections.observableArrayList();
    private ObservableMap<String, Duration> markers = FXCollections.observableMap(new HashMap());
    private final String source;
    private final Locator jfxLocator;
    private MetadataParser jfxParser;

    private void setError(MediaException value) {
        if (this.getError() == null) {
            this.errorPropertyImpl().set(value);
        }
    }

    public final MediaException getError() {
        return this.error == null ? null : (MediaException)this.error.get();
    }

    public ReadOnlyObjectProperty<MediaException> errorProperty() {
        return this.errorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<MediaException> errorPropertyImpl() {
        if (this.error == null) {
            this.error = new ReadOnlyObjectWrapper<MediaException>(){

                @Override
                protected void invalidated() {
                    if (Media.this.getOnError() != null) {
                        Platform.runLater(Media.this.getOnError());
                    }
                }

                @Override
                public Object getBean() {
                    return Media.this;
                }

                @Override
                public String getName() {
                    return "error";
                }
            };
        }
        return this.error;
    }

    public final void setOnError(Runnable value) {
        this.onErrorProperty().set(value);
    }

    public final Runnable getOnError() {
        return this.onError == null ? null : (Runnable)this.onError.get();
    }

    public ObjectProperty<Runnable> onErrorProperty() {
        if (this.onError == null) {
            this.onError = new ObjectPropertyBase<Runnable>(){

                @Override
                protected void invalidated() {
                    if (this.get() != null && Media.this.getError() != null) {
                        Platform.runLater((Runnable)this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Media.this;
                }

                @Override
                public String getName() {
                    return "onError";
                }
            };
        }
        return this.onError;
    }

    public final ObservableMap<String, Object> getMetadata() {
        return this.metadata;
    }

    final void setWidth(int value) {
        this.widthPropertyImpl().set(value);
    }

    public final int getWidth() {
        return this.width == null ? 0 : this.width.get();
    }

    public ReadOnlyIntegerProperty widthProperty() {
        return this.widthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper widthPropertyImpl() {
        if (this.width == null) {
            this.width = new ReadOnlyIntegerWrapper(this, "width");
        }
        return this.width;
    }

    final void setHeight(int value) {
        this.heightPropertyImpl().set(value);
    }

    public final int getHeight() {
        return this.height == null ? 0 : this.height.get();
    }

    public ReadOnlyIntegerProperty heightProperty() {
        return this.heightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper heightPropertyImpl() {
        if (this.height == null) {
            this.height = new ReadOnlyIntegerWrapper(this, "height");
        }
        return this.height;
    }

    final void setDuration(Duration value) {
        this.durationPropertyImpl().set(value);
    }

    public final Duration getDuration() {
        return this.duration == null || this.duration.get() == null ? Duration.UNKNOWN : (Duration)this.duration.get();
    }

    public ReadOnlyObjectProperty<Duration> durationProperty() {
        return this.durationPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> durationPropertyImpl() {
        if (this.duration == null) {
            this.duration = new ReadOnlyObjectWrapper(this, "duration");
        }
        return this.duration;
    }

    public final ObservableList<Track> getTracks() {
        return this.tracks;
    }

    public final ObservableMap<String, Duration> getMarkers() {
        return this.markers;
    }

    public Media(@NamedArg(value="source") String source) {
        this.source = source;
        URI uri = null;
        try {
            uri = new URI(source);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
        this.metadata = FXCollections.unmodifiableObservableMap(this.metadataBacking);
        this.tracks = FXCollections.unmodifiableObservableList(this.tracksBacking);
        Locator locator = null;
        try {
            this.jfxLocator = locator = new Locator(uri);
            if (locator.canBlock()) {
                InitLocator locatorInit = new InitLocator();
                Thread t = new Thread(locatorInit);
                t.setDaemon(true);
                t.start();
            } else {
                locator.init();
                this.runMetadataParser();
            }
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
        catch (FileNotFoundException fnfe) {
            throw new MediaException(MediaException.Type.MEDIA_UNAVAILABLE, fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new MediaException(MediaException.Type.MEDIA_INACCESSIBLE, ioe.getMessage());
        }
        catch (com.sun.media.jfxmedia.MediaException me) {
            throw new MediaException(MediaException.Type.MEDIA_UNSUPPORTED, me.getMessage());
        }
    }

    private void runMetadataParser() {
        try {
            this.jfxParser = MediaManager.getMetadataParser(this.jfxLocator);
            this.jfxParser.addListener(this.metadataListener);
            this.jfxParser.startParser();
        }
        catch (Exception e) {
            this.jfxParser = null;
        }
    }

    public String getSource() {
        return this.source;
    }

    Locator retrieveJfxLocator() {
        return this.jfxLocator;
    }

    private Track getTrackWithID(long trackID) {
        for (Track track : this.tracksBacking) {
            if (track.getTrackID() != trackID) continue;
            return track;
        }
        return null;
    }

    void _updateMedia(com.sun.media.jfxmedia.Media _media) {
        try {
            List<com.sun.media.jfxmedia.track.Track> trackList = _media.getTracks();
            if (trackList != null) {
                for (com.sun.media.jfxmedia.track.Track trackElement : trackList) {
                    long trackID = trackElement.getTrackID();
                    if (this.getTrackWithID(trackID) != null) continue;
                    Track newTrack = null;
                    HashMap<String, Object> trackMetadata = new HashMap<String, Object>();
                    if (null != trackElement.getName()) {
                        trackMetadata.put("name", trackElement.getName());
                    }
                    if (null != trackElement.getLocale()) {
                        trackMetadata.put("locale", trackElement.getLocale());
                    }
                    trackMetadata.put("encoding", trackElement.getEncodingType().toString());
                    trackMetadata.put("enabled", trackElement.isEnabled());
                    if (trackElement instanceof com.sun.media.jfxmedia.track.VideoTrack) {
                        com.sun.media.jfxmedia.track.VideoTrack vt = (com.sun.media.jfxmedia.track.VideoTrack)trackElement;
                        int videoWidth = vt.getFrameSize().getWidth();
                        int videoHeight = vt.getFrameSize().getHeight();
                        this.setWidth(videoWidth);
                        this.setHeight(videoHeight);
                        trackMetadata.put("video width", videoWidth);
                        trackMetadata.put("video height", videoHeight);
                        newTrack = new VideoTrack(trackElement.getTrackID(), trackMetadata);
                    } else if (trackElement instanceof com.sun.media.jfxmedia.track.AudioTrack) {
                        newTrack = new AudioTrack(trackElement.getTrackID(), trackMetadata);
                    } else if (trackElement instanceof com.sun.media.jfxmedia.track.SubtitleTrack) {
                        newTrack = new SubtitleTrack(trackID, trackMetadata);
                    }
                    if (null == newTrack) continue;
                    this.tracksBacking.add(newTrack);
                }
            }
        }
        catch (Exception e) {
            this.setError(new MediaException(MediaException.Type.UNKNOWN, (Throwable)e));
        }
    }

    void _setError(MediaException.Type type, String message) {
        this.setError(new MediaException(type, message));
    }

    private synchronized void updateMetadata(Map<String, Object> metadata) {
        if (metadata != null) {
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.equals("image") && value instanceof byte[]) {
                    byte[] imageData = (byte[])value;
                    Image image = new Image(new ByteArrayInputStream(imageData));
                    if (image.isError()) continue;
                    this.metadataBacking.put("image", image);
                    continue;
                }
                if (key.equals("duration") && value instanceof Long) {
                    Duration d = new Duration(((Long)value).longValue());
                    if (d == null) continue;
                    this.metadataBacking.put("duration", d);
                    continue;
                }
                this.metadataBacking.put(key, value);
            }
        }
    }

    private class InitLocator
    implements Runnable {
        private InitLocator() {
        }

        @Override
        public void run() {
            try {
                Media.this.jfxLocator.init();
                Media.this.runMetadataParser();
            }
            catch (URISyntaxException use) {
                Media.this._setError(MediaException.Type.OPERATION_UNSUPPORTED, use.getMessage());
            }
            catch (FileNotFoundException fnfe) {
                Media.this._setError(MediaException.Type.MEDIA_UNAVAILABLE, fnfe.getMessage());
            }
            catch (IOException ioe) {
                Media.this._setError(MediaException.Type.MEDIA_INACCESSIBLE, ioe.getMessage());
            }
            catch (com.sun.media.jfxmedia.MediaException me) {
                Media.this._setError(MediaException.Type.MEDIA_UNSUPPORTED, me.getMessage());
            }
            catch (Exception e) {
                Media.this._setError(MediaException.Type.UNKNOWN, e.getMessage());
            }
        }
    }

    private class _MetadataListener
    implements MetadataListener {
        private _MetadataListener() {
        }

        @Override
        public void onMetadata(Map<String, Object> metadata) {
            Platform.runLater(() -> {
                Media.this.updateMetadata(metadata);
                Media.this.jfxParser.removeListener(Media.this.metadataListener);
                Media.this.jfxParser.stopParser();
                Media.this.jfxParser = null;
            });
        }
    }
}

