/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.management;

import android.support.annotation.NonNull;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.management.ComponentPropertyInfo;
import org.terasology.gestalt.entitysystem.component.management.ComponentType;
import org.terasology.gestalt.entitysystem.component.management.ComponentTypeFactory;
import org.terasology.gestalt.entitysystem.component.management.ComponentTypeGenerationException;
import org.terasology.gestalt.entitysystem.component.management.PropertyAccessor;
import org.terasology.gestalt.util.reflection.GenericsUtil;

public abstract class AbstractComponentTypeFactory
implements ComponentTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponentTypeFactory.class);
    private static final Converter<String, String> TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);

    @Override
    @NonNull
    public <T extends Component<T>> ComponentType<T> createComponentType(Class<T> type) {
        Collection<PropertyAccessor<T, ?>> propertyAccessors = this.discoverProperties(type);
        if (propertyAccessors.isEmpty()) {
            return this.createSingletonComponentType(type);
        }
        Supplier emptyConstructor = this.getEmptyConstructor(type);
        if (emptyConstructor == null) {
            throw new ComponentTypeGenerationException("Component '" + type + "' missing empty constructor");
        }
        Function<Object, Object> copyConstructor = this.getCopyConstructor(type);
        if (copyConstructor == null) {
            copyConstructor = from -> {
                Component result = (Component)emptyConstructor.get();
                result.copy(from);
                return result;
            };
        }
        return new ComponentType<T>(type, emptyConstructor, copyConstructor, new ComponentPropertyInfo<T>(propertyAccessors));
    }

    protected abstract <T extends Component<T>> Function<T, T> getCopyConstructor(Class<T> var1);

    protected abstract <T extends Component<T>> Supplier<T> getEmptyConstructor(Class<T> var1);

    protected abstract <T extends Component<T>> Function<T, Object> createGetterFunction(Method var1, String var2, Type var3, Class<T> var4) throws Throwable;

    protected abstract <T extends Component<T>> BiConsumer<T, Object> createSetterFunction(Method var1, String var2, Type var3, Class<T> var4) throws Throwable;

    private <T extends Component<T>> ComponentType<T> createSingletonComponentType(Class<T> type) {
        try {
            Component instance = (Component)type.newInstance();
            return new ComponentType<Component>(type, () -> instance, t -> instance, new ComponentPropertyInfo(Collections.emptySet()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ComponentTypeGenerationException("Component lacks an empty constructor: " + type, e);
        }
    }

    private <T extends Component<T>> Collection<PropertyAccessor<T, ?>> discoverProperties(Class<T> componentType) {
        ArrayList accessorList = Lists.newArrayList();
        for (Method method : componentType.getDeclaredMethods()) {
            Method getter;
            if (method.getGenericReturnType() != Void.TYPE || !method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            String propertyName = method.getName().substring(3);
            Type setterType = method.getGenericParameterTypes()[0];
            String getterMethodName = Boolean.TYPE.equals(setterType) ? "is" + propertyName : "get" + propertyName;
            try {
                getter = componentType.getDeclaredMethod(getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                logger.error("Unable to find getter {}", (Object)getterMethodName);
                continue;
            }
            Type getterType = getter.getGenericReturnType();
            Type propertyType = null;
            if (!getterType.equals(setterType)) {
                Class setClass = GenericsUtil.getClassOfType((Type)setterType);
                Class getClass = GenericsUtil.getClassOfType((Type)getterType);
                if (getClass != null && setClass != null) {
                    if (getClass.isAssignableFrom(setClass)) {
                        propertyType = getterType;
                    } else if (setClass.isAssignableFrom(getClass)) {
                        propertyType = setterType;
                    }
                }
            } else {
                propertyType = setterType;
            }
            if (propertyType == null) {
                logger.error("Property type mismatch for '{}' between getter and setter", TO_LOWER_CAMEL.convert((Object)propertyName));
                continue;
            }
            try {
                accessorList.add(new PropertyAccessor<T, Object>((String)TO_LOWER_CAMEL.convert((Object)propertyName), componentType, propertyType, this.createGetterFunction(getter, propertyName, getterType, componentType), this.createSetterFunction(method, propertyName, setterType, componentType)));
            }
            catch (Throwable t) {
                logger.error("Failed to create accessor for property {} of {}", new Object[]{propertyName, componentType, t});
            }
        }
        return accessorList;
    }
}

