/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.management;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.management.ComponentType;
import org.terasology.gestalt.entitysystem.component.management.ComponentTypeFactory;
import org.terasology.gestalt.entitysystem.component.management.ReflectionComponentTypeFactory;

public class ComponentManager {
    private static final Logger logger = LoggerFactory.getLogger(ComponentManager.class);
    private final ComponentTypeFactory componentTypeFactory;
    private final Map<Class<?>, ComponentType<?>> componentTypes = new ConcurrentHashMap();

    public ComponentManager() {
        this.componentTypeFactory = new ReflectionComponentTypeFactory();
    }

    public ComponentManager(ComponentTypeFactory componentTypeFactory) {
        this.componentTypeFactory = componentTypeFactory;
    }

    public <T extends Component> T create(Class<T> type) {
        ComponentType<Class<T>> typeInfo = this.getType((T)((Object)type));
        return (T)typeInfo.create();
    }

    public <T extends Component> T copy(T instance) {
        ComponentType<T> typeInfo = this.getType(instance);
        return typeInfo.createCopy(instance);
    }

    public <T extends Component> ComponentType<T> getType(Class<T> type) {
        ComponentType<Object> typeInfo = this.componentTypes.get(type);
        if (typeInfo == null) {
            typeInfo = this.componentTypeFactory.createComponentType(type);
            this.componentTypes.put(type, typeInfo);
        }
        return typeInfo;
    }

    public <T extends Component> ComponentType<T> getType(T instance) {
        return this.getType((T)((Object)instance.getClass()));
    }

    public void clearCache() {
        this.componentTypes.clear();
    }
}

