/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.management;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.management.PropertyAccessor;

public class ComponentPropertyInfo<T extends Component> {
    private final Map<String, PropertyAccessor<T, ?>> properties;
    private final ImmutableMultimap<Class<?>, PropertyAccessor<T, ?>> propertiesByType;

    public ComponentPropertyInfo(Collection<PropertyAccessor<T, ?>> accessors) {
        ImmutableMap.Builder nameIndexBuilder = ImmutableMap.builder();
        accessors.forEach(x -> nameIndexBuilder.put((Object)x.getName(), x));
        this.properties = nameIndexBuilder.build();
        ImmutableMultimap.Builder typeIndexBuilder = ImmutableMultimap.builder();
        accessors.forEach(x -> typeIndexBuilder.put(x.getPropertyClass(), x));
        this.propertiesByType = typeIndexBuilder.build();
    }

    public Map<String, PropertyAccessor<T, ?>> getProperties() {
        return this.properties;
    }

    public Optional<PropertyAccessor<T, ?>> getProperty(String name) {
        return Optional.ofNullable(this.properties.get(name));
    }

    public Collection<PropertyAccessor<T, ?>> getPropertiesOfType(Class<?> type) {
        return this.propertiesByType.get(type);
    }
}

