/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.management;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import java.util.function.Supplier;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.management.ComponentPropertyInfo;

public final class ComponentType<T extends Component> {
    private final Class<T> type;
    private final Supplier<T> constructor;
    private final Function<T, T> copyConstructor;
    private final ComponentPropertyInfo<T> propertyInfo;

    public ComponentType(Class<T> type, Supplier<T> constructor, Function<T, T> copyConstructor, ComponentPropertyInfo<T> propertyInfo) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(constructor);
        Preconditions.checkNotNull(copyConstructor);
        this.type = type;
        this.constructor = constructor;
        this.copyConstructor = copyConstructor;
        this.propertyInfo = propertyInfo;
    }

    public T create() {
        return (T)((Component)this.constructor.get());
    }

    public T createCopy(T original) {
        return (T)((Component)this.copyConstructor.apply(original));
    }

    public Class<T> getComponentClass() {
        return this.type;
    }

    public ComponentPropertyInfo<T> getPropertyInfo() {
        return this.propertyInfo;
    }
}

